/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.base.integration.dingding;

import com.alibaba.fastjson.JSON;
import com.dingtalk.api.response.OapiSnsGetuserinfoBycodeResponse;
import com.dingtalk.api.response.OapiUserGetResponse;
import com.dingtalk.api.response.OapiUserGetUseridByUnionidResponse;
import com.fshows.auth.base.integration.dingding.entity.DDUserByCodeResponse;
import com.fshows.auth.base.integration.dingding.entity.DDUserByUnionidResponse;
import com.fshows.auth.base.integration.dingding.entity.DDUserByUseridResponse;
import com.fshows.auth.common.redis.RedisCache;
import com.fshows.auth.common.util.BeanCopierUtil;
import com.fshows.auth.common.util.DateFormatUtil;
import com.fshows.auth.common.util.SystemClock;
import com.fshows.auth.common.util.dingding.DingDingClient;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DingDingIntegration {
    private static final Logger log = LoggerFactory.getLogger(DingDingIntegration.class);
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private DingDingClient dingDingClient;

    public DDUserByCodeResponse getUserByCode(String code) {
        log.info("\u3010\u8c03\u7528\u9489\u9489\u63a5\u53e3\u3011 \u6839\u636e\u6388\u6743\u7801\u83b7\u53d6\u7528\u6237\u5f00\u59cb >> code={}\uff0c\u5f00\u59cb\u65f6\u95f4={}", (Object)code, (Object)DateFormatUtil.formatDateTime((Date)new Date()));
        long start = SystemClock.millisClock().now();
        OapiSnsGetuserinfoBycodeResponse response = this.dingDingClient.getUserByCode(code);
        log.info("\u3010\u8c03\u7528\u9489\u9489\u63a5\u53e3\u3011 \u6839\u636e\u6388\u6743\u7801\u83b7\u53d6\u7528\u6237\u7ed3\u675f >> code={}\uff0c\u7ed3\u675f\u65f6\u95f4={}\uff0c\u8fd4\u56de\u7ed3\u679c={}\uff0c\u8017\u65f6={}", new Object[]{code, DateFormatUtil.formatDateTime((Date)new Date()), JSON.toJSON((Object)response), SystemClock.millisClock().now() - start});
        DDUserByCodeResponse result = (DDUserByCodeResponse)BeanCopierUtil.copy((Object)response, DDUserByCodeResponse.class);
        return result;
    }

    public DDUserByUnionidResponse getUserContactType(String unionid) {
        log.info("\u3010\u8c03\u7528\u9489\u9489\u63a5\u53e3\u3011 \u6839\u636eunionid\u83b7\u53d6userid\u5f00\u59cb >> unionid={}\uff0c\u5f00\u59cb\u65f6\u95f4={}", (Object)unionid, (Object)DateFormatUtil.formatDateTime((Date)new Date()));
        long start = SystemClock.millisClock().now();
        OapiUserGetUseridByUnionidResponse response = this.dingDingClient.getUserContactType(unionid, this.getAccessToken());
        log.info("\u3010\u8c03\u7528\u9489\u9489\u63a5\u53e3\u3011 \u6839\u636eunionid\u83b7\u53d6userid\u7ed3\u675f >> unionid={}\uff0c\u7ed3\u675f\u65f6\u95f4={}\uff0c\u8fd4\u56de\u7ed3\u679c={}\uff0c\u8017\u65f6={}", new Object[]{unionid, DateFormatUtil.formatDateTime((Date)new Date()), JSON.toJSON((Object)response), SystemClock.millisClock().now() - start});
        DDUserByUnionidResponse result = (DDUserByUnionidResponse)BeanCopierUtil.copy((Object)response, DDUserByUnionidResponse.class);
        return result;
    }

    public DDUserByUseridResponse getUserByUserid(String userid) {
        log.info("\u3010\u8c03\u7528\u9489\u9489\u63a5\u53e3\u3011 \u6839\u636euserid\u83b7\u53d6\u7528\u6237\u8be6\u60c5\u5f00\u59cb >> userid={}\uff0c\u5f00\u59cb\u65f6\u95f4={}", (Object)userid, (Object)DateFormatUtil.formatDateTime((Date)new Date()));
        long start = SystemClock.millisClock().now();
        OapiUserGetResponse response = this.dingDingClient.getUserByUserid(userid, this.getAccessToken());
        log.info("\u3010\u8c03\u7528\u9489\u9489\u63a5\u53e3\u3011 \u6839\u636euserid\u83b7\u53d6\u7528\u6237\u8be6\u60c5\u7ed3\u675f >> userid={}\uff0c\u7ed3\u675f\u65f6\u95f4={}\uff0c\u8fd4\u56de\u7ed3\u679c={}\uff0c\u8017\u65f6={}", new Object[]{userid, DateFormatUtil.formatDateTime((Date)new Date()), JSON.toJSON((Object)response), SystemClock.millisClock().now() - start});
        DDUserByUseridResponse result = (DDUserByUseridResponse)BeanCopierUtil.copy((Object)response, DDUserByUseridResponse.class);
        return result;
    }

    private String getAccessToken() {
        log.info("\u3010\u8c03\u7528redis\u3011 \u83b7\u53d6redis\u7f13\u5b58accessToken\u5f00\u59cb >> \u5f00\u59cb\u65f6\u95f4={}", (Object)DateFormatUtil.formatDateTime((Date)new Date()));
        long start = SystemClock.millisClock().now();
        String accessToken = this.redisCache.get("fshows.auth.dingding.access.token");
        log.info("\u3010\u8c03\u7528redis\u3011 \u83b7\u53d6redis\u7f13\u5b58accessToken\u7ed3\u675f >> \u7ed3\u675f\u65f6\u95f4={}\uff0caccessToken={}\uff0c\u8017\u65f6={}", new Object[]{DateFormatUtil.formatDateTime((Date)new Date()), accessToken, SystemClock.millisClock().now() - start});
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            start = SystemClock.millisClock().now();
            log.info("\u3010\u8c03\u7528\u9489\u9489\u63a5\u53e3\u3011 \u83b7\u53d6\u9489\u9489\u5fae\u5e94\u7528accessToken\u5f00\u59cb >> \u5f00\u59cb\u65f6\u95f4={}", (Object)DateFormatUtil.formatDateTime((Date)new Date()));
            accessToken = this.dingDingClient.getAccessToken();
            log.info("\u3010\u8c03\u7528\u9489\u9489\u63a5\u53e3\u3011 \u83b7\u53d6\u9489\u9489\u5fae\u5e94\u7528accessToken\u7ed3\u675f >> \u7ed3\u675f\u65f6\u95f4={}\uff0caccessToken={}\uff0c\u8017\u65f6={}", new Object[]{DateFormatUtil.formatDateTime((Date)new Date()), accessToken, SystemClock.millisClock().now() - start});
            this.redisCache.set("fshows.auth.dingding.access.token", (Object)accessToken, 6000, TimeUnit.SECONDS);
        }
        return accessToken;
    }
}

