/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.enums;

/**
 * 实际的消息生产者类型
 *
 * @author liluqing
 * @version ProducerParamWrapEnum.java, v 0.1 2021-11-19 14:45
 */
public enum ProducerTypeEnum {

    /**
     * 枚举列表
     */
    DEFAULT_NOMAL_PRODUCER("DEFAULT_FS_PRODUCER", "默认普通消息生产者"),
    TRANSACTION_MESSAGE_PRODUCER("TRANSACTION_FS_PRODUCER", "事务消息生产者"),;

    private String name;
    private String value;

    ProducerTypeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static ProducerTypeEnum getByValue(String value) {
        ProducerTypeEnum[] valueList = ProducerTypeEnum.values();
        for (ProducerTypeEnum v : valueList) {
            if (v.getValue().equalsIgnoreCase(value)) {
                return v;
            }
        }
        return null;
    }
}