package com.fshows.ark.spring.boot.starter.enums;

/**
 * 消费者入参类型
 *
 * @author liluqing
 * @version RocketConsumerParamTypeEnum.java, v 0.1 2019-08-16 14:38
 */
public enum ConsumerParamTypeEnum {
    /**
     * 枚举列表
     */
    ALIYUN_MESSAGE("阿里云message", "com.aliyun.openservices.ons.api.Message"),
    FS_MESSAGE("首展message", "com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage"),
    MESSAGE_BODY_STRING("消息内容字符串", "java.lang.String"),
    ;

    private String name;
    private String value;

    ConsumerParamTypeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static ConsumerParamTypeEnum getByValue(String value) {
        ConsumerParamTypeEnum[] valueList = ConsumerParamTypeEnum.values();
        for (ConsumerParamTypeEnum v : valueList) {
            if (v.getValue().equals(value)) {
                return v;
            }
        }
        return null;
    }
}