/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer;


import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerInvoke;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerModel;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendResult;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IFshowsProducer;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.TransactionMessageManage;
import com.fshows.ark.spring.boot.starter.enums.ProducerReturnTypeEnum;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;

/**
 * 生产者动态代理类
 *
 * @author liluqing
 * @version RocketProducerProxy.java, v 0.1 2021-08-18 17:20
 */
@Slf4j
public class RocketProducerProxyHandler implements InvocationHandler {

    /**
     * 生产者bean
     */
    private IFshowsProducer producer;

    /**
     * 事务消息管理器
     */
    private TransactionMessageManage transactionMessageManage;

    /**
     * 生产者接口元信息
     */
    private FsProducerModel fsProducerModel;

    /**
     * 保存接口中发送方法的源数据
     */
    private Map<Method, RocketSendMessageMethodModel> sendMessageMethodMap;

    public RocketProducerProxyHandler(IFshowsProducer producer, FsProducerModel fsProducerModel, TransactionMessageManage transactionMessageManage) {
        this.producer = producer;
        this.sendMessageMethodMap = fsProducerModel.getSendMessageMethodModelMap();
        this.fsProducerModel = fsProducerModel;
        this.transactionMessageManage = transactionMessageManage;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        // 如果是object的默认实现,则调用该方法的默认实现,比如toString、equals等
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke(this, args);
        }
        // 本次消息发送的元信息
        RocketSendMessageMethodModel sendMessageMethod = sendMessageMethodMap.get(method);
        // 构建本次消息发送的上下文对象
        FsMessageSendContext messageSendcontext = buildMessageSendContext(sendMessageMethod, args);
        // 执行消息发送处理
        FsSendResult sendResult = sendMessage(messageSendcontext, producer);
        // 判断当前方法返回值类型,如果是无返回值,则返回null
        return ProducerReturnTypeEnum.VOID.equals(sendMessageMethod.getReturnTypeEnum()) ? null : sendResult;
    }

    /**
     * 消息发送处理
     *
     * @param messageSendcontext
     * @param producer
     * @return
     */
    private FsSendResult sendMessage(FsMessageSendContext messageSendcontext, IFshowsProducer producer) {
        FsSendResult sendResult = producer.send(messageSendcontext);
        return sendResult;
    }

    /**
     * 构建消息发送上下文
     *
     * @return
     */
    private FsMessageSendContext buildMessageSendContext(RocketSendMessageMethodModel rocketSendMessageMethodModel, Object[] args) {
        FsMessageSendContext context = new FsMessageSendContext();
        context.setRocketSendMessageMethodModel(rocketSendMessageMethodModel);
        context.setProducerSendTypeEnum(rocketSendMessageMethodModel.getSendTypeEnum());
        context.setProducerTypeEnum(rocketSendMessageMethodModel.getProducerTypeEnum());
        // 消息发送成功回调
        FsProducerInvoke producerInvoke = rocketSendMessageMethodModel.getParamTypeEnum().getFsProducerInvoke();
        FsSendSuccessCallback successCallback = producerInvoke.buildFsSendSuccessCallback(rocketSendMessageMethodModel, args);
        context.setSuccessCallback(successCallback);
        // 消息发送失败回调
        FsSendErrorCallback errorCallback = producerInvoke.buildFsSendErrorCallback(rocketSendMessageMethodModel, args);
        context.setErrorCallback(errorCallback);

        // 本次发送的消息内容
        FsMessage fsMessage = producerInvoke.buildFsMessage(rocketSendMessageMethodModel, args);
        context.setFsMessage(fsMessage);
        return context;
    }
}