/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.constant;

/**
 * mq配置常量类
 *
 * @author liluqing
 * @version MqConfigConstant.java, v 0.1 2021-09-03 10:28
 */
public class MqConfigConstant {

    /**
     * nameServer地址
     */
    public final static String NAME_SERVER_ADDR = "${ark.mq.name-server:}";


    /**
     * 生产者默认groupId
     */
    public final static String PRODUCER_DEFAULT_GROUP = "${ark.mq.producer.default-group:}";

    /**
     * 生产者消息发送超时时间
     */
    public final static String PRODUCER_SEND_MSG_TIMEOUT = "${ark.mq.producer.send-msg-timeout:10000}";

    /**
     * 生产者内容bety[]与String互转时的编码格式
     */
    public final static String PRODUCER_CONTENT_CHARSET = "${ark.mq.producer.content-charset:UTF-8}";

    /**
     * 事务超时时间
     */
    public final static String PRODUCER_TRANSACTION_TIME_OUT = "${ark.mq.producer.time.out:10000}";


    /**
     * 消费者消息内容bety[]与String互转时的编码格式
     */
    public final static String CONSUME_CONTENT_CHARSET = "${ark.mq.consume.content-charset:UTF-8}";

    /**
     * 消费者线程池默认线程数
     */
    public final static String CONSUME_DEFAULT_THREAD_NUM = "${ark.mq.consume.default-thread-num:8}";

    /**
     * 消费者消费失败默认重试次数
     */
    public final static String CONSUME_DEFAULT_MAX_RECONSUME_TIMES = "${ark.mq.consume.default-max-reconsume-times:16}";

    /**
     * 消费者消费每条消息消费的最大超时时间,超过这个时间,这条消息将会被视为消费失败,等下次重新投递再次消费. 每个业务需要设置一个合理的值. 单位(分钟)
     */
    public final static String CONSUME_DEFAULT_TIMEOUT = "${ark.mq.consume.default-consume-timeout:15}";

}