/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.constant;

/**
 * 通用常量
 *
 * @author Liluqing
 * @version CommonConstant.java, v 0.1 2019-08-15 11:05
 */
public class CommonConstant {

    /**
     * 动态属性前缀
     */
    public final static String DYNAMIC_PROPERTY_PREFIX = "${";

    /**
     * 动态属性前缀2
     */
    public final static String DYNAMIC_PROPERTY_PREFIX2 = "#{";

    /**
     * 动态属性后缀
     */
    public final static String DYNAMIC_PROPERTY_SUFFIX = "}";

    /**
     * 阿里云的主域名
     */
    public final static String ALIYUN_DOMAIN_NAME ="aliyuncs.com";

    /**
     * none
     */
    public final static String NONE = "none";

    /**
     * true
     */
    public final static String BOOLEAN_TRUE = "true";

    /**
     * 密钥缓存key
     * 格式：{密钥ID}_{算法类型ID}
     */
    public final static String SECRETKEY_CACHE_MAP_KEY = "{}_{}";

    /**
     * 加密密文默认前缀
     */
    public final static String CIPHERTEXT_PREFIX = "$fb$";

    /**
     * 密文默认分割符
     */
    public final static String CIPHERTEXT_SEPARATOR = "$";

    /**
     * 搜索字段分段加密起始字符数
     */
    public final static int ENCRYPT_QUERY_MIN_LENGTH = 3;
}