/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.annotation.mq;

import com.fshows.ark.spring.boot.starter.constant.MqConfigConstant;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 事务消息注解用于标记该消息为事务消息
 *
 * @author liluqing
 * @version RocketMessage.java, v 0.1 2021-08-12 19:54
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.ANNOTATION_TYPE})
@Inherited
public @interface TransactionMessage {

    /**
     * 本地发送超时时间,当超过该超时时间后消息认为发送,当前应用讲不会再尝试发送消息
     * （超时后，消息将交由定时任务脚本发送）
     *
     * @return
     */
    String localTimeOut() default MqConfigConstant.PRODUCER_TRANSACTION_TIME_OUT;
}