/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.annotation.encrypt;

import com.fshows.ark.spring.boot.starter.configuration.DbSensitiveAutoConfig;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 启用数据库敏感数据加密服务
 *
 * @author liluqing
 * @version EnableDbSensitiveEncrypt.java, v 0.1 2024-05-28 10:45
 */
@Component
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
@Import({DbSensitiveAutoConfig.class})
public @interface EnableDbSensitiveEncrypt {

}