/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.sensitive.encrypt;

import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.IFieldEncryptStrategy;
import com.fshows.ark.spring.boot.starter.core.sensitive.enums.AlgorithmTypeEnum;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class FieldEncryptFactory
implements ApplicationContextAware {
    private final Map<AlgorithmTypeEnum, IFieldEncryptStrategy> ENCRYPT_STRATEGY_CACHE_MAP = new ConcurrentHashMap<AlgorithmTypeEnum, IFieldEncryptStrategy>();
    private ApplicationContext applicationContext;

    @PostConstruct
    public void initMap() {
        Map map = this.applicationContext.getBeansOfType(IFieldEncryptStrategy.class);
        if (map.isEmpty()) {
            return;
        }
        for (IFieldEncryptStrategy iFieldEncryptStrategy : map.values()) {
            this.ENCRYPT_STRATEGY_CACHE_MAP.put(iFieldEncryptStrategy.getAlgorithmTypeEnum(), iFieldEncryptStrategy);
        }
    }

    public IFieldEncryptStrategy getFieldEncryptStrategy(AlgorithmTypeEnum algorithmTypeEnum) {
        return this.ENCRYPT_STRATEGY_CACHE_MAP.get((Object)algorithmTypeEnum);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

