/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.sensitive.encrypt;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.DefaultSecretKeyManage;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.FieldEncryptExecutor;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.FieldEncryptFactory;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.IFieldEncryptStrategy;
import com.fshows.ark.spring.boot.starter.core.sensitive.enums.AlgorithmTypeEnum;
import com.fshows.ark.spring.boot.starter.core.sensitive.model.SecretKeyModel;
import com.fshows.ark.spring.boot.starter.exception.DbSensitiveException;
import com.fshows.ark.spring.boot.starter.util.FsByteUtil;
import com.fshows.ark.spring.boot.starter.util.LogUtil;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultFieldEncryptExecutor
implements FieldEncryptExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultFieldEncryptExecutor.class);
    @Autowired
    private FieldEncryptFactory fieldEncryptFactory;
    @Autowired
    private DefaultSecretKeyManage defaultSecretKeyManage;

    @Override
    public String encrypt(String plaintext) {
        SecretKeyModel secretKeyModel = this.defaultSecretKeyManage.getMainEncryptSecretKey();
        return this.encrypt(plaintext, secretKeyModel);
    }

    private String encrypt(String plaintext, SecretKeyModel secretKeyModel) {
        if (StrUtil.isBlank((CharSequence)plaintext)) {
            return plaintext;
        }
        if (!this.isPlaintext(plaintext)) {
            return plaintext;
        }
        AlgorithmTypeEnum algorithmTypeEnum = secretKeyModel.getAlgorithmType();
        byte[] keyIdByte = FsByteUtil.splitBytes(secretKeyModel.getKeyId());
        byte[] algorithmTypeByte = FsByteUtil.splitBytes(algorithmTypeEnum.getValue());
        byte[] headBytes = new byte[]{keyIdByte[0], keyIdByte[1], algorithmTypeByte[0], algorithmTypeByte[1]};
        String ciphertext = this.doEncrypt(headBytes, plaintext, secretKeyModel);
        return "$fb$" + ciphertext;
    }

    private String doEncrypt(byte[] headBytes, String plaintext, SecretKeyModel secretKeyModel) {
        IFieldEncryptStrategy encryptStrategy = this.fieldEncryptFactory.getFieldEncryptStrategy(secretKeyModel.getAlgorithmType());
        byte[] cipherBytes = encryptStrategy.encrypt(StrUtil.bytes((CharSequence)plaintext, (Charset)CharsetUtil.CHARSET_UTF_8), secretKeyModel);
        byte[] reslutCipherBytes = FsByteUtil.mergeByteArrays(headBytes, cipherBytes);
        return Base64.encode((byte[])reslutCipherBytes);
    }

    @Override
    public String encrypt(String plaintext, String secretName) {
        SecretKeyModel secretKeyModel = this.defaultSecretKeyManage.getSecretKeyByName(secretName);
        if (secretKeyModel == null) {
            LogUtil.error(log, "ark-spring-boot-starter >> \u6570\u636e\u5e93\u654f\u611f\u5b57\u6bb5\u52a0\u5bc6 >> \u672a\u627e\u5230secretName\u4e3a'{}'\u7684\u5bc6\u94a5\u4fe1\u606f", secretName);
            throw new DbSensitiveException("ark-spring-boot-starter >> \u6570\u636e\u5e93\u654f\u611f\u5b57\u6bb5\u52a0\u5bc6 >> \u672a\u627e\u5230secretName\u4e3a" + secretName + "\u7684\u5bc6\u94a5\u4fe1\u606f");
        }
        return this.encrypt(plaintext, secretKeyModel);
    }

    @Override
    public String encryptSearchKeywords(String plaintext) {
        SecretKeyModel secretKeyModel = this.defaultSecretKeyManage.getSearchKeywordsSecret();
        return this.encryptSearchKeywords(plaintext, secretKeyModel);
    }

    private String encryptSearchKeywords(String plaintext, SecretKeyModel secretKeyModel) {
        if (StrUtil.isBlank((CharSequence)plaintext)) {
            return plaintext;
        }
        if (!this.isPlaintext(plaintext)) {
            return plaintext;
        }
        AlgorithmTypeEnum algorithmTypeEnum = secretKeyModel.getAlgorithmType();
        byte[] keyIdByte = FsByteUtil.splitBytes(secretKeyModel.getKeyId());
        byte[] algorithmTypeByte = FsByteUtil.splitBytes(algorithmTypeEnum.getValue());
        byte[] headBytes = new byte[]{keyIdByte[0], keyIdByte[1], algorithmTypeByte[0], algorithmTypeByte[1]};
        int length = plaintext.length();
        if (length <= 3) {
            String ciphertext = this.doEncrypt(headBytes, plaintext, secretKeyModel);
            return "$fb$" + ciphertext;
        }
        StringBuilder result = new StringBuilder(1000);
        result.append("$fb$");
        for (int i = 3; i <= length; ++i) {
            String partCiphertext = this.doEncrypt(headBytes, StrUtil.subWithLength((String)plaintext, (int)0, (int)i), secretKeyModel);
            result.append(partCiphertext);
            if (i == length) continue;
            result.append("$");
        }
        return result.toString();
    }

    @Override
    public String encryptSearchKeywords(String plaintext, String secretName) {
        SecretKeyModel secretKeyModel = this.defaultSecretKeyManage.getSecretKeyByName(secretName);
        return this.encryptSearchKeywords(plaintext, secretKeyModel);
    }

    @Override
    public String decrypt(String ciphertext) {
        if (this.isPlaintext(ciphertext)) {
            return ciphertext;
        }
        String[] base64DataArray = StrUtil.split((CharSequence)ciphertext, (CharSequence)"$");
        if (base64DataArray == null || base64DataArray.length < 2) {
            return null;
        }
        String base64Data = this.getLastNotBlankStr(base64DataArray);
        byte[] plain = Base64.decode((String)base64Data);
        if (plain == null || plain.length <= 4) {
            return null;
        }
        int keyId = FsByteUtil.mergeBytes(plain[1], plain[0]);
        int algorithmType = FsByteUtil.mergeBytes(plain[3], plain[2]);
        AlgorithmTypeEnum algorithmTypeEnum = AlgorithmTypeEnum.getByValue(algorithmType);
        SecretKeyModel secretKeyModel = this.defaultSecretKeyManage.getSecretKey(Integer.toString(keyId), algorithmTypeEnum);
        IFieldEncryptStrategy encryptStrategy = this.fieldEncryptFactory.getFieldEncryptStrategy(algorithmTypeEnum);
        byte[] body = new byte[plain.length - 4];
        System.arraycopy(plain, 4, body, 0, body.length);
        byte[] plainData = encryptStrategy.decrypt(body, secretKeyModel);
        return StrUtil.str((byte[])plainData, (Charset)CharsetUtil.CHARSET_UTF_8);
    }

    private String getLastNotBlankStr(String[] list) {
        for (int i = list.length - 1; i >= 0; --i) {
            String str = list[i];
            if (!StrUtil.isNotBlank((CharSequence)str)) continue;
            return str;
        }
        return null;
    }

    private boolean isPlaintext(String plaintext) {
        return !StrUtil.startWith((CharSequence)plaintext, (CharSequence)"$fb$");
    }
}

