/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.util;

import com.aliyun.openservices.shade.io.netty.util.CharsetUtil;
import com.fshows.ark.spring.boot.starter.util.CharUtil;
import com.fshows.ark.spring.boot.starter.util.StrFormatter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class StrUtil {
    private static final String EMPTY_STR = "";
    public static final char C_BACKSLASH = '\\';
    public static final String EMPTY_JSON = "{}";
    public static final char C_DELIM_START = '{';

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return null;
        }
        if (StrUtil.arrayIsEmpty(params) || StrUtil.isBlank(template)) {
            return template.toString();
        }
        return StrFormatter.format(template.toString(), params);
    }

    public static <T> boolean arrayIsEmpty(T ... array) {
        return array == null || array.length == 0;
    }

    public static String utf8Str(Object obj) {
        return StrUtil.str(obj, CharsetUtil.UTF_8);
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StrUtil.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StrUtil.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StrUtil.str((ByteBuffer)obj, charset);
        }
        if (StrUtil.isArray(obj)) {
            return StrUtil.arrayToString(obj);
        }
        return obj.toString();
    }

    public static String arrayToString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (StrUtil.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception e) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return Arrays.toString((long[])obj);
                    }
                    case "int": {
                        return Arrays.toString((int[])obj);
                    }
                    case "short": {
                        return Arrays.toString((short[])obj);
                    }
                    case "char": {
                        return Arrays.toString((char[])obj);
                    }
                    case "byte": {
                        return Arrays.toString((byte[])obj);
                    }
                    case "boolean": {
                        return Arrays.toString((boolean[])obj);
                    }
                    case "float": {
                        return Arrays.toString((float[])obj);
                    }
                    case "double": {
                        return Arrays.toString((double[])obj);
                    }
                }
                throw new RuntimeException(e);
            }
        }
        return obj.toString();
    }

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static String ifNullDefault(String str, String defaultStr) {
        return str != null && str.length() > 0 ? str : defaultStr;
    }

    public static String ifNullDefault(Object str, String defaultStr) {
        if (str == null) {
            return defaultStr;
        }
        return StrUtil.ifNullDefault(str.toString(), defaultStr);
    }

    public static String ifNullDefaultEmpty(String str) {
        return StrUtil.ifNullDefault(str, EMPTY_STR);
    }

    public static String ifNullDefaultEmpty(Object str) {
        if (str == null) {
            return EMPTY_STR;
        }
        return StrUtil.ifNullDefault(str, EMPTY_STR);
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharUtil.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

