/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs;

import android.content.Context;
import android.text.TextUtils;
import anet.channel.d;
import anet.channel.entity.ENV;
import com.taobao.accs.ACCSManager;
import com.taobao.accs.AccsClientConfig;
import com.taobao.accs.AccsException;
import com.taobao.accs.IACCSManager;
import com.taobao.accs.IAppReceiver;
import com.taobao.accs.ILoginInfo;
import com.taobao.accs.base.AccsAbstractDataListener;
import com.taobao.accs.base.TaoBaseService;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.l;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ACCSClient {
    protected IACCSManager mAccsManager;
    private static String TAG = "ACCSClient";
    private String OTAG = TAG;
    private static Context mContext;
    private AccsClientConfig mConfig;
    public static Map<String, ACCSClient> mACCSClients;

    public ACCSClient(Context context, AccsClientConfig accsClientConfig) {
        this.mConfig = accsClientConfig;
        this.OTAG = this.OTAG + accsClientConfig.getTag();
        this.mAccsManager = ACCSManager.getAccsInstance(mContext, accsClientConfig.getAppKey(), accsClientConfig.getTag());
    }

    public static synchronized String init(Context context, String object) throws AccsException {
        if (context == null || TextUtils.isEmpty((CharSequence)object)) {
            throw new AccsException("params error");
        }
        object = new AccsClientConfig.Builder().setAppKey((String)object).build();
        return ACCSClient.init(context, (AccsClientConfig)object);
    }

    public static synchronized String init(Context context, AccsClientConfig accsClientConfig) throws AccsException {
        if (context == null || accsClientConfig == null) {
            throw new AccsException("params error");
        }
        mContext = context.getApplicationContext();
        ALog.i(TAG, "init", "config", accsClientConfig.toString());
        return accsClientConfig.getTag();
    }

    public static synchronized ACCSClient getAccsClient(String string) throws AccsException {
        AccsClientConfig accsClientConfig;
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "default";
            ALog.e(TAG, "configTag null, use default!", new Object[0]);
        }
        if ((accsClientConfig = AccsClientConfig.getConfigByTag(string)) == null) {
            ALog.e(TAG, "configTag not exist, please init first!!", new Object[0]);
            throw new AccsException("tag not exist");
        }
        ALog.i(TAG, "getAccsClient", "configTag", string);
        ACCSClient aCCSClient = mACCSClients.get(string);
        if (aCCSClient == null) {
            ALog.i(TAG, "getAccsClient create client", "config", accsClientConfig.toString());
            aCCSClient = new ACCSClient(mContext, accsClientConfig);
            mACCSClients.put(string, aCCSClient);
            return aCCSClient;
        }
        if (accsClientConfig.equals(aCCSClient.mConfig)) {
            ALog.i(TAG, "getAccsClient exists", new Object[0]);
            return aCCSClient;
        }
        ALog.i(TAG, "getAccsClient update config", "old config", aCCSClient.mConfig.getTag(), "new config", accsClientConfig.getTag());
        aCCSClient.updateConfig(accsClientConfig);
        return aCCSClient;
    }

    private void updateConfig(AccsClientConfig accsClientConfig) {
        this.mConfig = accsClientConfig;
        this.mAccsManager = ACCSManager.getAccsInstance(mContext, accsClientConfig.getAppKey(), accsClientConfig.getTag());
        this.mAccsManager.updateConfig(accsClientConfig);
    }

    public static synchronized void setEnvironment(Context context, @AccsClientConfig.ENV int n2) {
        int n3 = n2;
        try {
            if (n2 < 0 || n2 > 2) {
                ALog.e(TAG, "env error", "env", n2);
                n3 = 0;
            }
            n2 = AccsClientConfig.mEnv;
            AccsClientConfig.mEnv = n3;
            if (n2 != n3 && l.d(context)) {
                ALog.i(TAG, "setEnvironment:" + n3, new Object[0]);
                l.b(context);
                l.e(context);
                l.c(context);
                if (n3 == 2) {
                    d.a(ENV.TEST);
                } else if (n3 == 1) {
                    d.a(ENV.PREPARE);
                }
                for (Map.Entry<String, ACCSClient> entry : mACCSClients.entrySet()) {
                    try {
                        ACCSClient.getAccsClient(entry.getKey());
                    }
                    catch (AccsException accsException) {
                        ALog.e(TAG, "setEnvironment update client", accsException, new Object[0]);
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "setEnvironment", throwable, new Object[0]);
            return;
        }
        finally {
            l.a(context, n3);
        }
    }

    public void bindApp(String string, IAppReceiver iAppReceiver) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "bindApp mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.bindApp(mContext, this.mConfig.getAppKey(), this.mConfig.getAppSecret(), string, iAppReceiver);
    }

    public void bindUser(String string) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "bindUser mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.bindUser(mContext, string);
    }

    public void bindUser(String string, boolean bl) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "bindUser mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.bindUser(mContext, string, bl);
    }

    public void unbindUser() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "unbindUser mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.unbindUser(mContext);
    }

    public void bindService(String string) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "bindService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.bindService(mContext, string);
    }

    public void unbindService(String string) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "unbindService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.unbindService(mContext, string);
    }

    public String sendData(ACCSManager.AccsRequest accsRequest) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "sendData mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.sendData(mContext, accsRequest);
    }

    public String sendRequest(ACCSManager.AccsRequest accsRequest) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "sendRequest mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.sendRequest(mContext, accsRequest);
    }

    public String sendPushResponse(ACCSManager.AccsRequest accsRequest, TaoBaseService.ExtraInfo extraInfo) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "sendPushResponse mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.sendPushResponse(mContext, accsRequest, extraInfo);
    }

    public boolean isNetworkReachable() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "isNetworkReachable mAccsManager null", new Object[0]);
            return false;
        }
        return this.mAccsManager.isNetworkReachable(mContext);
    }

    public void forceDisableService() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "forceDisableService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.forceDisableService(mContext);
    }

    public void forceEnableService() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "forceEnableService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.forceEnableService(mContext);
    }

    public void startInAppConnection(String string, IAppReceiver iAppReceiver) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "startInAppConnection mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.startInAppConnection(mContext, this.mConfig.getAppKey(), this.mConfig.getAppSecret(), string, iAppReceiver);
    }

    public void setLoginInfo(ILoginInfo iLoginInfo) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "setLoginInfo mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.setLoginInfo(mContext, iLoginInfo);
    }

    public void clearLoginInfo() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "clearLoginInfo mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.clearLoginInfo(mContext);
    }

    public boolean cancel(String string) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "cancel mAccsManager null", new Object[0]);
            return false;
        }
        return this.mAccsManager.cancel(mContext, string);
    }

    public boolean isChannelError(int n2) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "isChannelError mAccsManager null", new Object[0]);
            return true;
        }
        return this.mAccsManager.isChannelError(n2);
    }

    public Map<String, Boolean> getChannelState() throws Exception {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "getChannelState mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.getChannelState();
    }

    public Map<String, Boolean> forceReConnectChannel() throws Exception {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "forceReConnectChannel mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.forceReConnectChannel();
    }

    public String getUserUnit() {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "getUserUnit mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.getUserUnit();
    }

    public void registerSerivce(String string, String string2) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "registerSerivce mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.registerSerivce(mContext, string, string2);
    }

    public void unRegisterSerivce(String string) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "unRegisterSerivce mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.unRegisterSerivce(mContext, string);
    }

    public void registerDataListener(String string, AccsAbstractDataListener accsAbstractDataListener) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "registerDataListener mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.registerDataListener(mContext, string, accsAbstractDataListener);
    }

    public void unRegisterDataListener(String string) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "unRegisterDataListener mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.unRegisterDataListener(mContext, string);
    }

    public void sendBusinessAck(String string, String string2, String string3, short s2, String string4, Map<TaoBaseService.ExtHeaderType, String> map) {
        if (this.mAccsManager == null) {
            ALog.e(this.OTAG, "sendBusinessAck mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.sendBusinessAck(string, string2, string3, s2, string4, map);
    }

    static {
        mACCSClients = new ConcurrentHashMap<String, ACCSClient>(2);
    }
}

