/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.szpush.receiver;

import android.content.Context;
import android.util.Log;
import com.igexin.sdk.GTIntentService;
import com.igexin.sdk.PushManager;
import com.igexin.sdk.message.GTCmdMessage;
import com.igexin.sdk.message.GTNotificationMessage;
import com.igexin.sdk.message.GTTransmitMessage;
import com.shouzhan.szpush.manager.GeTuiManager;
import com.shouzhan.szpush.manager.PushChannel;
import com.shouzhan.szpush.mix.MixPushMessage;
import com.shouzhan.szpush.push.IPushChannel;
import org.json.JSONObject;

public class GeTuiMessageIntentService
extends GTIntentService
implements IPushChannel {
    private static final String TAG = GeTuiMessageIntentService.class.getSimpleName();

    @Override
    public String getPushName() {
        return PushChannel.getui.name();
    }

    public void onReceiveServicePid(Context context, int pid) {
        Log.d((String)TAG, (String)("onReceiveServicePid -> " + pid));
    }

    public void onReceiveMessageData(Context context, GTTransmitMessage msg) {
        try {
            String taskId = msg.getTaskId();
            String messageId = msg.getMessageId();
            PushManager.getInstance().sendFeedbackMessage(context, taskId, messageId, 90001);
            byte[] payload = msg.getPayload();
            String data = new String(payload);
            Log.e((String)TAG, (String)("onReceiveMessageData: " + new String(payload)));
            JSONObject object = new JSONObject(data);
            JSONObject msgObject = object.getJSONObject("on_message");
            int passType = msgObject.getInt("pass_type");
            MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
            if (passType == 1) {
                mixPushMessage.setContent(data);
                GeTuiManager.sMixMessageProvider.onReceivePassThroughMessage(context, mixPushMessage);
            } else {
                mixPushMessage.setMsgObject(msgObject.toString());
                GeTuiManager.sMixMessageProvider.onNotificationMessageClicked(context, mixPushMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onReceiveClientId(Context context, String clientId) {
        Log.d((String)TAG, (String)("onReceiveClientId: clientId = " + clientId));
        MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
        mixPushMessage.setCid(clientId);
        GeTuiManager.sMixMessageProvider.onReceiveClientId(context, mixPushMessage);
    }

    public void onReceiveOnlineState(Context context, boolean online) {
        Log.e((String)TAG, (String)("onReceiveOnlineState: " + (online ? "online" : "offline")));
    }

    public void onReceiveCommandResult(Context context, GTCmdMessage cmdMessage) {
        Log.e((String)TAG, (String)("onReceiveCommandResult: " + cmdMessage));
    }

    public void onNotificationMessageArrived(Context context, GTNotificationMessage gtNotificationMessage) {
        Log.e((String)TAG, (String)("onNotificationMessageArrived: " + gtNotificationMessage.getContent()));
    }

    public void onNotificationMessageClicked(Context context, GTNotificationMessage gtNotificationMessage) {
        Log.e((String)TAG, (String)"onNotificationMessageClicked");
    }
}

