/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.szpush.receiver;

import android.content.Context;
import android.util.Log;
import com.alibaba.sdk.android.push.MessageReceiver;
import com.alibaba.sdk.android.push.notification.CPushMessage;
import com.shouzhan.szpush.manager.AliPushManager;
import com.shouzhan.szpush.manager.PushChannel;
import com.shouzhan.szpush.mix.MixPushMessage;
import com.shouzhan.szpush.push.IPushChannel;
import java.util.Map;
import org.json.JSONObject;

public class AliMessageReceiver
extends MessageReceiver
implements IPushChannel {
    private static final String TAG = AliMessageReceiver.class.getSimpleName();

    @Override
    public String getPushName() {
        return PushChannel.aliyun.name();
    }

    protected void onNotificationOpened(Context context, String title, String summary, String extra) {
        super.onNotificationOpened(context, title, summary, extra);
        Log.e((String)TAG, (String)("onNotificationOpened\uff1a " + extra));
        MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
        mixPushMessage.setMsgObject(extra);
        AliPushManager.sMixMessageProvider.onNotificationMessageClicked(context, mixPushMessage);
    }

    protected void onNotificationRemoved(Context context, String messageId) {
        super.onNotificationRemoved(context, messageId);
        Log.e((String)TAG, (String)("onNotificationRemoved: " + messageId));
    }

    protected void onMessage(Context context, CPushMessage cPushMessage) {
        super.onMessage(context, cPushMessage);
        Log.e((String)TAG, (String)("onMessage: " + cPushMessage.getContent()));
        MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
        mixPushMessage.setContent(cPushMessage.getContent());
        mixPushMessage.setTitle(cPushMessage.getTitle());
        AliPushManager.sMixMessageProvider.onReceivePassThroughMessage(context, mixPushMessage);
    }

    protected void onNotification(Context context, String title, String summary, Map<String, String> msgExtra) {
        super.onNotification(context, title, summary, msgExtra);
        Log.e((String)TAG, (String)("onNotification\uff1a " + title + " summary: " + summary + " extra: " + msgExtra.toString()));
        try {
            String msgCode;
            JSONObject object;
            if (msgExtra == null || msgExtra.isEmpty()) {
                return;
            }
            if (msgExtra.containsKey("on_message")) {
                object = new JSONObject(msgExtra.get("on_message"));
                msgCode = object.optString("code");
            } else {
                msgCode = msgExtra.get("code");
                object = new JSONObject(msgExtra.get("data"));
            }
            String orderSn = object.optString("order_sn");
            String uniqueId = object.isNull("key") ? object.optString("order_id") : object.optString("key");
            MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
            mixPushMessage.setMsgCode(msgCode);
            mixPushMessage.setOrderSn(orderSn);
            mixPushMessage.setOrderId(uniqueId);
            AliPushManager.sMixMessageProvider.onNotificationMessageArrived(context, mixPushMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onNotificationReceivedInApp(Context context, String s, String s1, Map<String, String> map, int i, String s2, String s3) {
        super.onNotificationReceivedInApp(context, s, s1, map, i, s2, s3);
        Log.e((String)TAG, (String)("onNotificationReceivedInApp: " + map.toString()));
    }

    protected void onNotificationClickedWithNoAction(Context context, String title, String summary, String extraMap) {
        super.onNotificationClickedWithNoAction(context, title, summary, extraMap);
        Log.e((String)TAG, (String)("onNotificationClickedWithNoAction: " + extraMap));
    }

    protected void onConnectionStatusChanged(boolean changed) {
        super.onConnectionStatusChanged(changed);
        Log.i((String)TAG, (String)("onConnectionStatusChanged" + changed));
    }
}

