/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.szpush.mix;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import com.shouzhan.szpush.mix.MixMessageProvider;
import com.shouzhan.szpush.mix.MixPushIntentService;
import com.shouzhan.szpush.mix.MixPushManager;
import com.shouzhan.szpush.mix.MixPushMessage;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class MixPushClient {
    private static final String TAG = MixPushClient.class.getSimpleName();
    private static Map<String, MixPushManager> sPushManagerMap = new LinkedHashMap<String, MixPushManager>();
    private static String sReceiverPermission = null;
    private static Class<? extends MixPushIntentService> sMixPushIntentServiceClass;

    private MixPushClient() {
    }

    public static void setPushIntentService(Class<? extends MixPushIntentService> mixPushIntentServiceClass) {
        sMixPushIntentServiceClass = mixPushIntentServiceClass;
    }

    public static synchronized void addPushManager(Context context, MixPushManager pushAdapter) {
        sReceiverPermission = context.getPackageName() + ".permission.MIXPUSH_RECEIVE";
        sPushManagerMap.put(pushAdapter.getPushName(), pushAdapter);
        pushAdapter.setMessageProvider(new MixMessageProvider(){

            @Override
            public void onReceivePassThroughMessage(Context context, MixPushMessage message) {
                Intent intent = new Intent("com.mixpush.RECEIVE_THROUGH_MESSAGE");
                intent.putExtra("message", (Serializable)message);
                context.sendBroadcast(intent, sReceiverPermission);
                Log.e((String)TAG, (String)(message.getPlatform() + "\u6536\u5230\u900f\u4f20\u6d88\u606f ->  "));
                if (sMixPushIntentServiceClass != null) {
                    intent.setClass(context, sMixPushIntentServiceClass);
                    if (Build.VERSION.SDK_INT >= 26) {
                        context.startForegroundService(intent);
                    } else {
                        context.startService(intent);
                    }
                }
            }

            @Override
            public void onNotificationMessageClicked(Context context, MixPushMessage message) {
                Intent intent = new Intent("com.mixpush.NOTIFICATION_CLICKED");
                intent.putExtra("message", (Serializable)message);
                context.sendBroadcast(intent, sReceiverPermission);
                Log.e((String)TAG, (String)(message.getPlatform() + "\u901a\u77e5\u680f\u6d88\u606f\u70b9\u51fb -> "));
                if (sMixPushIntentServiceClass != null) {
                    intent.setClass(context, sMixPushIntentServiceClass);
                    if (Build.VERSION.SDK_INT >= 26) {
                        context.startForegroundService(intent);
                    } else {
                        context.startService(intent);
                    }
                }
            }

            @Override
            public void onNotificationMessageArrived(Context context, MixPushMessage message) {
                Intent intent = new Intent("com.mixpush.NOTIFICATION_ARRIVED");
                intent.putExtra("message", (Serializable)message);
                context.sendBroadcast(intent, sReceiverPermission);
                Log.e((String)TAG, (String)(message.getPlatform() + "\u901a\u77e5\u680f\u6d88\u606f -> "));
                if (sMixPushIntentServiceClass != null) {
                    intent.setClass(context, sMixPushIntentServiceClass);
                    if (Build.VERSION.SDK_INT >= 26) {
                        context.startForegroundService(intent);
                    } else {
                        context.startService(intent);
                    }
                }
            }

            @Override
            public void onReceiveClientId(Context context, MixPushMessage message) {
                Intent intent = new Intent("com.mixpush.CLIENT_ID");
                intent.putExtra("message", (Serializable)message);
                context.sendBroadcast(intent, sReceiverPermission);
                Log.e((String)TAG, (String)(message.getPlatform() + "\u63a8\u9001id ->" + message.getCid()));
                if (sMixPushIntentServiceClass != null) {
                    intent.setClass(context, sMixPushIntentServiceClass);
                    if (Build.VERSION.SDK_INT >= 26) {
                        context.startForegroundService(intent);
                    } else {
                        context.startService(intent);
                    }
                }
            }
        });
        pushAdapter.registerPush(context);
    }

    public static void unRegisterPush(Context context) {
    }
}

