/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.szpush.manager;

import android.content.Context;
import android.util.Log;
import com.alibaba.sdk.android.push.CloudPushService;
import com.alibaba.sdk.android.push.CommonCallback;
import com.alibaba.sdk.android.push.noonesdk.PushServiceFactory;
import com.shouzhan.szpush.R;
import com.shouzhan.szpush.manager.PushChannel;
import com.shouzhan.szpush.mix.MixMessageProvider;
import com.shouzhan.szpush.mix.MixPushManager;
import com.shouzhan.szpush.mix.MixPushMessage;
import com.shouzhan.szpush.utils.Utils;

public class AliPushManager
implements MixPushManager {
    private static final String TAG = AliPushManager.class.getSimpleName();
    public static MixMessageProvider sMixMessageProvider;
    private static CloudPushService mPushService;
    private static Context mContext;

    @Override
    public String getPushName() {
        return PushChannel.aliyun.name();
    }

    @Override
    public void registerPush(Context context) {
        mContext = context;
        PushServiceFactory.init((Context)context);
        mPushService = PushServiceFactory.getCloudPushService();
        mPushService.setLogLevel(2);
        mPushService.register(context, new CommonCallback(){

            public void onSuccess(String response) {
                MixPushMessage mixPushMessage = new MixPushMessage(AliPushManager.this.getPushName());
                mixPushMessage.setCid(mPushService.getDeviceId());
                sMixMessageProvider.onReceiveClientId(mContext, mixPushMessage);
                int logoId = mContext.getResources().getIdentifier(Utils.getIconName(mContext), "mipmap", mContext.getPackageName());
                mPushService.setNotificationSmallIcon(logoId);
                String soundPath = "android.resource://" + mContext.getPackageName() + "/" + R.raw.voice_notification_tip;
                mPushService.setNotificationSoundFilePath(soundPath);
            }

            public void onFailed(String errorCode, String errorMessage) {
                Log.d((String)TAG, (String)("initializing AliYun SDK is fail" + errorMessage));
            }
        });
    }

    @Override
    public void unRegisterPush(Context context) {
    }

    @Override
    public void setMessageProvider(MixMessageProvider provider) {
        sMixMessageProvider = provider;
    }

    static {
        mPushService = null;
        mContext = null;
    }
}

