/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.upload;

import android.content.Context;
import com.alibaba.sdk.android.oss.ClientConfiguration;
import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.OSS;
import com.alibaba.sdk.android.oss.OSSClient;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback;
import com.alibaba.sdk.android.oss.callback.OSSProgressCallback;
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.model.PutObjectRequest;
import com.alibaba.sdk.android.oss.model.PutObjectResult;
import com.shouzhan.clientcommon.CommonUtils;
import com.shouzhan.upload.GetOssToken;
import com.shouzhan.upload.OssUploadCallback;
import java.io.File;

public class OssService {
    private static final String END_POINT = "http://oss-cn-hangzhou.aliyuncs.com";
    private OSS ossService;
    private OssUploadCallback callback;
    private String bucketName;
    private String key;
    private String localFile;
    private int taskId;

    public OssService(Context mContext) {
        this.ossService = this.getDefaultOss(mContext);
    }

    public OSS getDefaultOss(Context mContext) {
        GetOssToken credentialProvider = new GetOssToken(mContext);
        ClientConfiguration conf = new ClientConfiguration();
        conf.setConnectionTimeout(15000);
        conf.setSocketTimeout(15000);
        conf.setMaxConcurrentRequest(5);
        conf.setMaxErrorRetry(2);
        return new OSSClient(mContext, END_POINT, (OSSCredentialProvider)credentialProvider, conf);
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setOSSUploadCallback(OssUploadCallback callback) {
        this.callback = callback;
    }

    public void uploadImage(String key, String localFile, int taskId) {
        this.key = key;
        this.localFile = localFile;
        this.taskId = taskId;
        this.asyncPutImage();
    }

    public void asyncPutImage() {
        if (CommonUtils.isStringInvalid(this.key)) {
            return;
        }
        File file = new File(this.localFile);
        if (!file.exists()) {
            return;
        }
        PutObjectRequest put = new PutObjectRequest(this.bucketName, this.key, this.localFile);
        put.setProgressCallback((OSSProgressCallback)new OSSProgressCallback<PutObjectRequest>(){

            public void onProgress(PutObjectRequest request, long currentSize, long totalSize) {
                if (OssService.this.callback != null) {
                    OssService.this.callback.onProgress(currentSize, totalSize, OssService.this.taskId);
                }
            }
        });
        this.ossService.asyncPutObject(put, (OSSCompletedCallback)new OSSCompletedCallback<PutObjectRequest, PutObjectResult>(){

            public void onSuccess(PutObjectRequest request, PutObjectResult result) {
                if (OssService.this.callback != null) {
                    OssService.this.callback.onSuccess(OssService.this.bucketName, OssService.this.key, OssService.this.taskId);
                }
            }

            public void onFailure(PutObjectRequest request, ClientException clientException, ServiceException serviceException) {
                if (OssService.this.callback != null) {
                    OssService.this.callback.onFailure(serviceException.getErrorCode(), OssService.this.taskId);
                }
            }
        });
    }
}

