/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.upload;

import android.content.Context;
import android.util.Log;
import com.shouzhan.clientcommon.CommonThreadPoolExecutor;
import com.shouzhan.upload.CompressBuilder;
import com.shouzhan.upload.ImageCompress;
import java.io.File;

public class Compress {
    private static final String TAG = Compress.class.getSimpleName();
    private Context mContext;
    private CompressBuilder mBuilder;
    private CutPicStateListener mCutPicState;
    private CommonThreadPoolExecutor mExecutor;

    public Compress(Context mContext) {
        this.mContext = mContext;
    }

    public Compress(Context mContext, CutPicStateListener cutPicState) {
        this.mContext = mContext;
        this.mCutPicState = cutPicState;
        this.mExecutor = new CommonThreadPoolExecutor();
    }

    public Compress setBuilder(CompressBuilder builder) {
        this.mBuilder = builder;
        return this;
    }

    public File compressToFile(File file) {
        return this.compressToFile(file.getAbsolutePath());
    }

    public File compressToFile(String srcPath) {
        try {
            if (this.mBuilder == null) {
                this.mBuilder = new CompressBuilder(this.mContext);
            }
            return ImageCompress.compressImage(srcPath, this.mBuilder);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("compress error: " + e.getMessage()));
            return null;
        }
    }

    public void compressFile(final String srcPath) {
        this.mCutPicState.begin();
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Compress.this.mBuilder == null) {
                        Compress.this.mBuilder = new CompressBuilder(Compress.this.mContext);
                    }
                    Compress.this.mCutPicState.success(ImageCompress.compressImage(srcPath, Compress.this.mBuilder));
                    Compress.this.mCutPicState.after();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("compress error: " + e.getMessage()));
                    Compress.this.mCutPicState.failure();
                }
            }
        });
    }

    public static interface CutPicStateListener {
        public void begin();

        public void after();

        public void success(File var1);

        public void failure();
    }
}

