/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.network;

import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import com.shouzhan.network.HttpTask;
import com.shouzhan.network.RequestThreadPoolExecutor;
import okhttp3.OkHttpClient;
import okhttp3.OkUrlFactory;

public class TaskDispatcher {
    static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private SparseArray<HttpTask> taskMap = new SparseArray();
    private static TaskDispatcher INSTANCE = null;
    protected OkUrlFactory urlFactory;
    protected RequestThreadPoolExecutor threadPool;

    private TaskDispatcher() {
        OkHttpClient.Builder mBuilder = new OkHttpClient.Builder();
        this.urlFactory = new OkUrlFactory(mBuilder.build());
    }

    public OkUrlFactory getOkUrlFactory() {
        return this.urlFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskDispatcher getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<TaskDispatcher> clazz = TaskDispatcher.class;
        synchronized (TaskDispatcher.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new TaskDispatcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void dispatch(HttpTask task) {
        this.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void execute(HttpTask task) {
        SparseArray<HttpTask> sparseArray = this.taskMap;
        synchronized (sparseArray) {
            task.setDispatcher(this);
            this.taskMap.put(task.id, (Object)task);
        }
        new Thread(task).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchInPool(HttpTask task) {
        SparseArray<HttpTask> sparseArray = this.taskMap;
        synchronized (sparseArray) {
            task.setDispatcher(this);
            this.taskMap.put(task.id, (Object)task);
            if (this.threadPool == null) {
                this.threadPool = new RequestThreadPoolExecutor();
            }
        }
        this.threadPool.execute(task);
    }

    public void cancel(int id2) {
        HttpTask tsk = this.get(id2);
        if (tsk != null) {
            tsk.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(int id2) {
        SparseArray<HttpTask> sparseArray = this.taskMap;
        synchronized (sparseArray) {
            this.taskMap.remove(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpTask get(int id2) {
        HttpTask tsk = null;
        SparseArray<HttpTask> sparseArray = this.taskMap;
        synchronized (sparseArray) {
            tsk = (HttpTask)this.taskMap.get(id2);
        }
        return tsk;
    }
}

