/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.network;

import android.content.Context;
import java.io.InputStream;

public abstract class BaseResult {
    protected int serverCode;
    protected int resultCode;
    protected String errorMsg = null;
    protected int errorCode = -1;
    protected boolean parseNeeded;
    protected Context context;
    protected String url;

    public BaseResult(Context context) {
        this.context = context;
        this.parseNeeded = true;
        this.serverCode = -1;
    }

    void setUrl(String url) {
        this.url = url;
    }

    protected boolean isParseNeeded() {
        return this.parseNeeded;
    }

    public void setParseNeeded(boolean parseNeeded) {
        this.parseNeeded = parseNeeded;
    }

    protected boolean doExtraJob() {
        return true;
    }

    protected boolean processStatus(int status) {
        this.serverCode = status;
        return false;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public int getServerCode() {
        return this.serverCode;
    }

    public void setServerCode(int serverCode) {
        this.serverCode = serverCode;
    }

    protected abstract boolean parseResponse(InputStream var1) throws Exception;

    protected boolean preProcess() {
        return false;
    }
}

