/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.network;

import android.content.Context;
import android.support.v4.util.ArrayMap;
import com.shouzhan.clientcommon.CommonUtils;
import com.shouzhan.clientcommon.DeviceHelper;
import com.shouzhan.clientcommon.InternalUtils;
import com.shouzhan.clientcommon.MD5Utils;
import com.shouzhan.clientcommon.RSAUtils;
import com.shouzhan.clientcommon.TokenUtils;
import com.shouzhan.clientcommon.UrlCfgUtils;
import com.shouzhan.network.BaseResult;
import com.shouzhan.network.TaskDispatcher;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Set;

public abstract class BaseRequest {
    private static final String TAG = "BaseRequest";
    private static final String CACHE_API = "/api/cacheZip";
    protected ArrayMap<String, Object> pathSegments;
    protected ArrayMap<String, String> headers;
    protected ArrayMap<String, String> customCommonHeaders;
    protected String url;
    protected RequestType requestMethod;
    protected BaseResult result;
    protected Context context;
    protected int retryTimes;
    protected boolean needToken;
    protected TaskDispatcher dispatcher;
    protected File cacheFile;

    public BaseRequest(Context context, BaseResult result) {
        this(context, result, true);
    }

    public BaseRequest(Context context, BaseResult result, boolean needToken) {
        if (result == null) {
            throw new NullPointerException("BaseResult must not be null !!!");
        }
        this.context = context;
        this.result = result;
        this.retryTimes = 3;
        this.needToken = needToken;
    }

    protected void setMethod(RequestType requestType) {
        this.requestMethod = requestType;
    }

    public String getFinalUrl() {
        return this.url;
    }

    protected void setUrlSegment(ArrayMap<String, Object> segments) {
        this.pathSegments = segments;
    }

    protected void setNeedToken(boolean needToken) {
        this.needToken = needToken;
    }

    @Deprecated
    public void setDispatcher(TaskDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public boolean isAlive() {
        return this.result.parseNeeded;
    }

    public BaseResult getResult() {
        return this.result;
    }

    public void cancel() {
        this.result.parseNeeded = false;
    }

    public boolean directSend() {
        this.dispatcher = TaskDispatcher.getInstance();
        return this.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send() {
        boolean ret;
        block22: {
            HttpURLConnection connection = null;
            InputStream is = null;
            try {
                ret = this.result.preProcess();
                if (ret) {
                    boolean bl = ret;
                    return bl;
                }
                this.onPreSent();
                this.retryTimes = this.getRetryTimes();
                this.requestMethod = this.getMethod();
                boolean success = this.configUrl();
                if (!success) {
                    boolean bl = ret;
                    return bl;
                }
                for (int i = 0; this.isAlive() && is == null && i < this.retryTimes; ++i) {
                    connection = this.openConnection();
                    this.setCommonHeaders(connection);
                    this.setAdditionalHeaders(connection);
                    switch (this.requestMethod) {
                        case GET: {
                            connection.setRequestMethod("GET");
                            this.processConnection(connection);
                            break;
                        }
                        case POST: {
                            connection.setRequestMethod("POST");
                            connection.setDoOutput(true);
                            connection.setDoOutput(true);
                            this.processConnection(connection);
                            this.flushPostData(connection);
                            break;
                        }
                    }
                    int statusCode = connection.getResponseCode();
                    if (statusCode == 401) {
                        Thread.sleep(1000L);
                        this.configUrl();
                        continue;
                    }
                    if (this.result.processStatus(statusCode)) {
                        this.configUrl();
                        continue;
                    }
                    if (!this.isResponseValid(statusCode)) {
                        Thread.sleep(1000L);
                        continue;
                    }
                    is = this.getInputStream(connection);
                    if (is != null) continue;
                    Thread.sleep(1000L);
                }
                if (is != null) {
                    ret = this.result.parseResponse(is);
                    if (ret && (ret = this.result.doExtraJob())) {
                        this.onPostSent();
                    }
                } else {
                    this.result.setServerCode(-1);
                }
                CommonUtils.silentClose(is);
            }
            catch (Exception e) {
                this.result.setServerCode(0);
                ret = false;
                break block22;
            }
            finally {
                CommonUtils.silentClose(is);
                CommonUtils.closeConnection(connection);
            }
            CommonUtils.closeConnection(connection);
        }
        if (!ret) {
            this.onSentError();
        }
        if (this.cacheFile != null) {
            this.cacheFile.delete();
        }
        return ret;
    }

    private boolean configUrl() {
        boolean success = false;
        this.url = this.getUrl();
        String appointHost = this.setAppointHost();
        this.fixHost(appointHost);
        if (this.isRequestUrlIllegal()) {
            return success;
        }
        this.pathSegments = this.appendUrlSegment();
        this.headers = this.getHeaders();
        if (this.requestMethod == RequestType.GET) {
            this.url = UrlCfgUtils.configNormalSegments(this.url, this.pathSegments);
        }
        this.result.setUrl(this.url);
        success = true;
        return success;
    }

    private boolean isRequestUrlIllegal() {
        return this.url == null || this.url.trim().length() < 0;
    }

    private HttpURLConnection openConnection() throws IOException {
        HttpURLConnection connection = this.dispatcher.urlFactory.open(new URL(this.url));
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(20000);
        connection.setDoInput(true);
        return connection;
    }

    private void setCommonHeaders(HttpURLConnection connection) {
        String token;
        if (this.customCommonHeaders == null || this.customCommonHeaders.isEmpty()) {
            String project = InternalUtils.constructProject(InternalUtils.obtainProjectName(this.context), InternalUtils.obtainChannel(this.context));
            String pkg = InternalUtils.obtainClientPackage(this.context);
            String version = InternalUtils.obtainClientVersion(this.context);
            String channel = this.fixChannel() == null ? InternalUtils.obtainChannel(this.context) : this.fixChannel();
            String platform = String.valueOf(1);
            int androidOs = DeviceHelper.getAndroidOSVersion();
            String system = String.valueOf(androidOs);
            String model = CommonUtils.getDevModel();
            String ua = InternalUtils.constructUA(project, pkg, version, channel, platform, system, model);
            connection.addRequestProperty("User-Agent", ua);
        } else {
            this.setCustomCommonHeaders(connection);
        }
        if (this.needToken && (token = TokenUtils.getToken(this.context)) != null) {
            connection.addRequestProperty("accessToken", token);
        }
        try {
            String sign = this.generationSign();
            if (sign != null) {
                connection.addRequestProperty("sign", CommonUtils.replaceBlank(sign.trim()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.addRequestProperty("signType", String.valueOf(this.getSignType()));
        connection.addRequestProperty("Accept-Encoding", "gzip,deflate,sdch");
        connection.addRequestProperty("Content-Type", "application/json");
    }

    private void setCustomCommonHeaders(HttpURLConnection connection) {
        Set entrys = this.customCommonHeaders.entrySet();
        for (Map.Entry entry : entrys) {
            connection.addRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void setAdditionalHeaders(HttpURLConnection connection) {
        if (this.headers == null || this.headers.isEmpty()) {
            return;
        }
        Set entrys = this.headers.entrySet();
        for (Map.Entry entry : entrys) {
            connection.addRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private String generationSign() throws Exception {
        String sign = null;
        StringBuilder builder = new StringBuilder();
        builder.append(UrlCfgUtils.getJsonData(this.appendUrlSegment()));
        switch (this.getSignType()) {
            case 1: {
                builder.append(UrlCfgUtils.getRandomKey());
                sign = MD5Utils.getStringMD5(builder.toString());
                break;
            }
            case 2: {
                sign = RSAUtils.sign(builder.toString().getBytes(), InternalUtils.obtainPrivateKey(this.context));
                break;
            }
        }
        return sign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPostData(HttpURLConnection conn) throws IOException {
        byte[] data = this.composePostData();
        if (data == null || data.length <= 0) {
            return;
        }
        conn.addRequestProperty("Content-Length", String.valueOf(data.length));
        OutputStream os = conn.getOutputStream();
        if (os == null) {
            return;
        }
        ByteArrayInputStream bais = null;
        try {
            int count;
            bais = new ByteArrayInputStream(data);
            byte[] buffer = new byte[2048];
            while ((count = bais.read(buffer)) != -1) {
                os.write(buffer, 0, count);
            }
            os.flush();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CommonUtils.silentClose(bais);
                CommonUtils.silentClose(os);
                throw throwable;
            }
            CommonUtils.silentClose(bais);
            CommonUtils.silentClose(os);
        }
        CommonUtils.silentClose(bais);
        CommonUtils.silentClose(os);
    }

    private InputStream getInputStream(HttpURLConnection connection) throws IOException {
        InputStream is = connection.getInputStream();
        if (is == null) {
            return is;
        }
        if (this.isZipStream(connection)) {
            if (this.url.contains(CACHE_API)) {
                this.cacheFile = InternalUtils.cacheZipStream(this.context, is);
                return new FileInputStream(this.cacheFile);
            }
            return InternalUtils.unZIP(is);
        }
        return is;
    }

    private boolean isZipStream(HttpURLConnection connection) {
        String contentEncoding = connection.getHeaderField("Content-Encoding");
        if (contentEncoding == null) {
            return false;
        }
        return contentEncoding.contains("gzip");
    }

    private boolean isResponseValid(int statusCode) {
        return statusCode == 200 || statusCode == 206 || statusCode == 302 || statusCode == 301;
    }

    private void fixHost(String appointHost) {
        if (CommonUtils.isStringInvalid(appointHost)) {
            return;
        }
        if (CommonUtils.isStringInvalid(this.url)) {
            return;
        }
        String prevHost = InternalUtils.extractHost(this.url);
        if (CommonUtils.isStringInvalid(prevHost)) {
            return;
        }
        this.url = this.url.replace(prevHost, appointHost);
    }

    protected abstract RequestType getMethod();

    protected abstract String getUrl();

    protected abstract ArrayMap<String, Object> appendUrlSegment();

    protected abstract ArrayMap<String, String> getHeaders();

    protected int getSignType() {
        return 1;
    }

    protected byte[] composePostData() {
        String jsonData = UrlCfgUtils.getJsonData(this.appendUrlSegment());
        if (CommonUtils.isStringInvalid(jsonData)) {
            return null;
        }
        return jsonData.getBytes();
    }

    protected int getRetryTimes() {
        return 3;
    }

    @Deprecated
    protected void constructCustomCommonHeaders() {
        this.customCommonHeaders = null;
    }

    protected ArrayMap<String, String> constructCustomSegments() {
        return null;
    }

    protected void onPreSent() {
    }

    protected void onPostSent() {
    }

    protected void onSentError() {
    }

    protected void processConnection(HttpURLConnection connection) {
    }

    protected String fixChannel() {
        return null;
    }

    protected String setAppointHost() {
        return null;
    }

    public static enum RequestType {
        GET,
        POST;

    }
}

