/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.log;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.shouzhan.log.FormatDebug;
import com.shouzhan.log.LogUtils;
import com.shouzhan.szcommon.R;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class LogcatActivity
extends FragmentActivity
implements View.OnClickListener,
AdapterView.OnItemClickListener {
    private static final String TAG = FormatDebug.closelyCallOuterClassName();
    private static final FormatDebug D = new FormatDebug(TAG);
    private View mLayoutLogFiles = null;
    private View mLayoutDisplayLog = null;
    private ListView mLogView = null;
    private WebView mWebView = null;
    private List<File> mLogFiles = new ArrayList<File>();
    private List<String> mLogList = new ArrayList<String>();
    private BaseAdapter mLogAdapter = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(16974065);
        this.setContentView(R.layout.activity_logcat);
        this.initUi();
        this.findLogFiles();
    }

    private void initUi() {
        this.mLogView = (ListView)this.findViewById(R.id.lv_logcat);
        this.mLogAdapter = new ArrayAdapter((Context)this, 17367043, this.mLogList);
        this.mLogView.setAdapter((ListAdapter)this.mLogAdapter);
        this.mLogView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mWebView = (WebView)this.findViewById(R.id.wv_display_logcat);
        this.mLayoutLogFiles = this.findViewById(R.id.layout_show_log_files);
        this.mLayoutDisplayLog = this.findViewById(R.id.layout_display_logcat);
        this.findViewById(R.id.btn_clean_files).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.btn_send_log).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.btn_umeng_meta).setOnClickListener((View.OnClickListener)this);
    }

    private void findLogFiles() {
        this.mLogFiles.clear();
        this.mLogList.clear();
        String logPath = LogUtils.logWriteDir((Context)this);
        File logDir = new File(logPath);
        if (!logDir.exists() || !logDir.canWrite()) {
            this.mLogList.add("\u6ca1\u6709\u53d1\u73b0\u5d29\u6e83\u65e5\u5fd7\u76ee\u5f55");
            this.mLogAdapter.notifyDataSetChanged();
            return;
        }
        File[] childs = logDir.listFiles();
        if (null == childs) {
            this.mLogList.add("\u83b7\u53d6\u5d29\u6e83\u65e5\u5fd7\u6587\u4ef6\u5217\u8868\u5931\u8d25");
            this.mLogAdapter.notifyDataSetChanged();
            return;
        }
        int size = childs.length;
        if (0 == size) {
            this.mLogList.add("\u5d29\u6e83\u6587\u4ef6\u5b58\u50a8\u6570\u91cf: " + size);
            this.mLogAdapter.notifyDataSetChanged();
            return;
        }
        File f = null;
        for (int i = 0; i < size; ++i) {
            f = childs[i];
            this.mLogFiles.add(0, f);
            this.mLogList.add(0, size - i + "  " + f.getAbsolutePath());
        }
        this.mLogAdapter.notifyDataSetChanged();
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getAction() != 0) {
            return super.dispatchKeyEvent(event);
        }
        if (event.getKeyCode() == 4 && this.mLayoutDisplayLog.getVisibility() == 0) {
            this.mLayoutDisplayLog.setVisibility(4);
            this.mLayoutLogFiles.setVisibility(0);
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.btn_clean_files) {
            D.debug("clean logs");
            this.showDeleteLogDialog();
            return;
        }
        if (view.getId() == R.id.btn_send_log) {
            D.debug("send log");
            return;
        }
        if (view.getId() == R.id.btn_umeng_meta) {
            this.showUmengMetaDialog();
            return;
        }
    }

    private void showUmengMetaDialog() {
    }

    private void showDeleteLogDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)"\u63d0\u793a");
        builder.setMessage((CharSequence)"\u662f\u5426\u5220\u9664\u5d29\u6e83\u65e5\u5fd7?");
        builder.setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                LogcatActivity.this.deleteLogFiles();
            }
        });
        builder.setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    private void deleteLogFiles() {
        String logPath = LogUtils.logWriteDir((Context)this);
        File logDir = new File(logPath);
        if (!logDir.exists() || !logDir.canWrite()) {
            return;
        }
        File[] childs = logDir.listFiles();
        if (null == childs) {
            return;
        }
        for (File f : childs) {
            f.delete();
        }
        this.findLogFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        String text = "";
        if (this.mLogFiles.size() - 1 < position) {
            text = "out of bound, mLogFiles size: " + this.mLogFiles.size() + ", position: " + position;
            this.mWebView.loadData(text, "text/html", "utf-8");
            return;
        }
        File f = this.mLogFiles.get(position);
        if (!f.exists()) {
            return;
        }
        FileInputStream is = null;
        InputStreamReader sReader = null;
        BufferedReader reader = null;
        try {
            is = new FileInputStream(f);
            sReader = new InputStreamReader((InputStream)is, "utf-8");
            reader = new BufferedReader(sReader);
            StringBuilder builder = new StringBuilder();
            builder.append("<html><body>");
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append("<p>");
                builder.append(line);
                builder.append("</p>");
            }
            builder.append("</body></html>");
            text = builder.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                    reader = null;
                }
                if (null != sReader) {
                    sReader.close();
                    sReader = null;
                }
                if (null != is) {
                    ((InputStream)is).close();
                    is = null;
                }
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
        this.mWebView.loadData(text, "text/html", "utf-8");
        this.mLayoutDisplayLog.setVisibility(0);
        this.mLayoutLogFiles.setVisibility(4);
    }
}

