/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.download;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import com.shouzhan.clientcommon.CommonUtils;
import com.shouzhan.clientcommon.MD5Utils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;

public class DownloadUtils {
    public static final String TEMP_FILE_SUFFIX = ".apk.tmp";
    public static final String FORMAL_FILE_SUFFIX = ".apk";
    private static final long MIN_SPACE = 0L;
    static final int DOWNLOAD_RETRY_TIMES = 2;
    private static String downloadRootPath;

    public static String genKeyForUrl(String url) {
        if (url == null) {
            return null;
        }
        String cacheKey = MD5Utils.getStringMD5(url.trim());
        if (CommonUtils.isStringInvalid(cacheKey)) {
            cacheKey = String.valueOf(url.hashCode());
        }
        return cacheKey;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    private static String getDownloadRootPathWithSdcard(Context context) {
        StringBuilder builder = new StringBuilder();
        File dirFile = Environment.getExternalStorageDirectory();
        if (dirFile == null || !dirFile.canWrite()) {
            return null;
        }
        builder.append(dirFile.getAbsolutePath()).append(File.separator).append("Download").append(File.separator).append(context.getPackageName());
        File file = new File(builder.toString());
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.canWrite()) {
            return null;
        }
        return file.getAbsolutePath();
    }

    private static String getDownloadRootPathWithoutSdcard(Context context) {
        String rootPath = context.getCacheDir().getAbsolutePath() + File.separator + "apps";
        String[] args1 = new String[]{"chmod", "705", rootPath};
        CommonUtils.exec(args1);
        return rootPath;
    }

    public static void resetDownloadRootPath(Context context) {
        downloadRootPath = null;
        DownloadUtils.getDownloadRootPath(context);
        Log.i((String)"DownloadUtils", (String)("downloadRootPath:" + downloadRootPath));
    }

    public static synchronized String getDownloadRootPath(Context context) {
        if (downloadRootPath == null) {
            String rootPath = null;
            try {
                if (rootPath == null && Build.VERSION.SDK_INT >= 23 && !DownloadUtils.canCreateFile(rootPath = DownloadUtils.getDownloadRootPathForApi19(context))) {
                    rootPath = null;
                }
                if (rootPath == null && Environment.getExternalStorageState().equals("mounted") && DownloadUtils.hasEnoughSpaceOnSDCard() && !DownloadUtils.canCreateFile(rootPath = DownloadUtils.getDownloadRootPathWithSdcard(context))) {
                    rootPath = null;
                }
                if (rootPath == null && Build.VERSION.SDK_INT >= 19 && !DownloadUtils.canCreateFile(rootPath = DownloadUtils.getDownloadRootPathForApi19(context))) {
                    rootPath = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (rootPath == null) {
                rootPath = DownloadUtils.getDownloadRootPathWithoutSdcard(context);
            }
            downloadRootPath = rootPath;
        } else if (downloadRootPath.startsWith(context.getCacheDir().getAbsolutePath())) {
            String[] args1 = new String[]{"chmod", "705", downloadRootPath};
            CommonUtils.exec(args1);
        }
        return downloadRootPath;
    }

    @TargetApi(value=19)
    public static String getDownloadRootPathForApi19(Context context) {
        String rootPath = null;
        File[] fs = context.getExternalFilesDirs(null);
        if (fs == null || fs.length == 0) {
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>(fs.length);
        for (File f : fs) {
            if (f == null) continue;
            if (!f.exists()) {
                f.mkdirs();
            }
            if (!f.isDirectory() || !f.canWrite() || !f.canRead()) continue;
            fileList.add(f);
        }
        if (fileList.size() == 0) {
            return null;
        }
        if (fileList.size() == 1) {
            ((File)fileList.get(0)).mkdirs();
            rootPath = ((File)fileList.get(0)).getAbsolutePath();
        } else {
            for (int i = 0; i < fileList.size(); ++i) {
                if (!DownloadUtils.hasEnoughSpaceOnSDCard()) continue;
                ((File)fileList.get(i)).mkdirs();
                rootPath = ((File)fileList.get(i)).getAbsolutePath();
            }
        }
        return rootPath;
    }

    private static boolean canCreateFile(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path, "file.test");
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            file.delete();
            return true;
        }
        try {
            boolean b = file.createNewFile();
            file.delete();
            return b;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean hasEnoughSpaceOnSDCard() {
        long availableBlocks;
        File file = Environment.getExternalStorageDirectory();
        if (!(file.exists() && file.canWrite() && file.canRead())) {
            Log.i((String)"DownloadUtils", (String)"file is not exists");
            return false;
        }
        StatFs stat = new StatFs(file.getAbsolutePath());
        long blockSize = stat.getBlockSize();
        return blockSize * (availableBlocks = (long)stat.getAvailableBlocks()) > 0L;
    }

    public static File createDownloadTempFile(Context context, String key) {
        String rootPath = DownloadUtils.getDownloadRootPath(context);
        File newFile = new File(rootPath, key + TEMP_FILE_SUFFIX);
        if (!newFile.getParentFile().exists()) {
            newFile.getParentFile().mkdirs();
        }
        return newFile;
    }

    public static File createDownloadFormalFile(Context context, String key) {
        String rootPath = DownloadUtils.getDownloadRootPath(context);
        File newFile = new File(rootPath, key + FORMAL_FILE_SUFFIX);
        if (!newFile.getParentFile().exists()) {
            newFile.getParentFile().mkdirs();
        }
        return newFile;
    }

    public static void renameFile(File tempFile, File newFile) {
        tempFile.renameTo(newFile);
    }

    public static File getDownloadFile(Context context, String key) {
        String rootPath = DownloadUtils.getDownloadRootPath(context);
        return DownloadUtils.getDownloadFile(context, key, rootPath);
    }

    public static File getDownloadFile(Context context, String key, String rootPath) {
        File rootDir = new File(rootPath);
        File[] files = rootDir.listFiles(new FileSearchComp(key));
        if (files == null || files.length <= 0) {
            return null;
        }
        return files[0];
    }

    public static File getDownloadFileByUrl(Context context, String url) {
        String key = DownloadUtils.genKeyForUrl(url);
        return DownloadUtils.getDownloadFile(context, key);
    }

    public static long getDownloadRange(Context context, String key) {
        File file = DownloadUtils.getDownloadFile(context, key);
        if (file == null) {
            return 0L;
        }
        return file.length();
    }

    public static boolean isCompleteFile(String path) {
        if (CommonUtils.isStringInvalid(path)) {
            return false;
        }
        return !path.endsWith(TEMP_FILE_SUFFIX);
    }

    private static final class FileSearchComp
    implements FilenameFilter {
        private String key;

        public FileSearchComp(String key) {
            this.key = key;
        }

        @Override
        public boolean accept(File dir, String filename) {
            if (null == this.key) {
                return false;
            }
            if (null == filename) {
                return false;
            }
            return filename.startsWith(this.key);
        }
    }
}

