/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.download;

import android.content.Context;
import android.os.Message;
import android.util.Log;
import com.shouzhan.clientcommon.CommonUtils;
import com.shouzhan.clientcommon.MD5Utils;
import com.shouzhan.download.DownloadCallback;
import com.shouzhan.download.DownloadDispatcher;
import com.shouzhan.download.DownloadObj;
import com.shouzhan.download.DownloadUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

class DownloadTask
implements Runnable {
    private static final String TAG = "DownloadTask";
    private static final String MATCH_CASE = "[^0-9]";
    private static final String BYTES = "bytes";
    private static final String REQUEST_METHOD = "GET";
    private static final String HEADER_RANGE = "RANGE";
    private static final int DEFAULT_READ_TIMEOUT = 20000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final long REPORT_PROGRESS_TIME_SPAN = 500L;
    protected DownloadDispatcher dispatcher;
    protected Context context;
    protected String url;
    protected DownloadCallback callback;
    protected String key;
    protected String md5;
    private long downloadedSize;
    private long totalSize;
    private boolean canceled;
    private int retryTimes;
    private File tempFile;
    private File apkFile;
    private boolean delete;

    public DownloadTask(Context context, String url) {
        this(context, url, null);
    }

    public DownloadTask(Context context, String url, DownloadCallback callback) {
        this(context, url, null, callback);
    }

    public DownloadTask(Context context, String url, String md5, DownloadCallback callback) {
        this(context, url, md5, callback, 0L);
    }

    public DownloadTask(Context context, String url, String md5, DownloadCallback callback, long totalSize) {
        this.context = context;
        this.url = url;
        this.md5 = md5;
        this.callback = callback;
        if (this.callback == null) {
            this.callback = new DownloadCallback.SimpleCallback();
        }
        this.downloadedSize = 0L;
        this.totalSize = totalSize;
        this.canceled = false;
        this.delete = false;
        this.retryTimes = 2;
    }

    public void setDispatcher(DownloadDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public boolean isAlive() {
        return !this.canceled && !this.delete;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() {
        this.canceled = true;
    }

    public boolean isDeleted() {
        return this.delete;
    }

    public void delete() {
        this.delete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.key = DownloadUtils.genKeyForUrl(this.url);
        this.reportDownloadStatus(1);
        HttpURLConnection connection = null;
        InputStream is = null;
        BufferedOutputStream bos = null;
        boolean success = false;
        for (int i = 0; this.isAlive() && is == null && i < this.retryTimes; ++i) {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        try {
                                            this.tempFile = DownloadUtils.getDownloadFile(this.context, this.key);
                                            if (this.tempFile == null) {
                                                this.tempFile = DownloadUtils.createDownloadTempFile(this.context, this.key);
                                            }
                                            this.downloadedSize = this.tempFile.length();
                                            if (this.totalSize > 0L && this.downloadedSize == this.totalSize) {
                                                if (this.checkFinish()) {
                                                    success = true;
                                                    CommonUtils.silentClose(bos);
                                                    break block23;
                                                }
                                                CommonUtils.silentClose(bos);
                                                break block24;
                                            }
                                            connection = this.openDownloadConnection();
                                            bos = new BufferedOutputStream(new FileOutputStream(this.tempFile, this.downloadedSize > 0L));
                                            this.attachFileRangeHeader(connection);
                                            int statusCode = connection.getResponseCode();
                                            if (statusCode != 200 && statusCode != 206) {
                                                if (statusCode == 416) {
                                                    this.performHttp416(connection);
                                                }
                                                CommonUtils.silentClose(bos);
                                                break block25;
                                            }
                                            if (this.isCanceled()) {
                                                this.reportDownloadStatus(6);
                                                CommonUtils.silentClose(bos);
                                                break block26;
                                            }
                                            if (this.isDeleted()) {
                                                this.tempFile.delete();
                                                this.reportDownloadStatus(7);
                                                CommonUtils.silentClose(bos);
                                                break block27;
                                            }
                                            is = connection.getInputStream();
                                            this.totalSize = this.parseFileSize(connection);
                                            if (this.totalSize == this.downloadedSize) {
                                                if (this.checkFinish()) {
                                                    success = true;
                                                    CommonUtils.silentClose(bos);
                                                    break block28;
                                                }
                                                CommonUtils.silentClose(bos);
                                                break block29;
                                            }
                                            this.save2File(is, bos);
                                            success = true;
                                            CommonUtils.silentClose(bos);
                                        }
                                        catch (Exception e) {
                                            if (this.isCanceled()) {
                                                this.reportDownloadStatus(6);
                                                continue;
                                            }
                                            if (is == null) continue;
                                            this.reportDownloadStatus(4);
                                            continue;
                                        }
                                    }
                                    CommonUtils.silentClose(is);
                                    CommonUtils.closeConnection(connection);
                                    break;
                                }
                                CommonUtils.silentClose(is);
                                CommonUtils.closeConnection(connection);
                                continue;
                            }
                            CommonUtils.silentClose(is);
                            CommonUtils.closeConnection(connection);
                            continue;
                        }
                        CommonUtils.silentClose(is);
                        CommonUtils.closeConnection(connection);
                        return;
                    }
                    CommonUtils.silentClose(is);
                    CommonUtils.closeConnection(connection);
                    return;
                }
                CommonUtils.silentClose(is);
                CommonUtils.closeConnection(connection);
                break;
            }
            CommonUtils.silentClose(is);
            CommonUtils.closeConnection(connection);
            continue;
            CommonUtils.silentClose(is);
            CommonUtils.closeConnection(connection);
            continue;
            finally {
                CommonUtils.silentClose(bos);
                CommonUtils.silentClose(is);
                CommonUtils.closeConnection(connection);
            }
        }
        if (success) return;
        if (this.isCanceled()) {
            this.reportDownloadStatus(6);
            return;
        }
        if (this.isDeleted()) {
            this.tempFile.delete();
            this.reportDownloadStatus(7);
            return;
        }
        this.reportDownloadStatus(4);
    }

    private HttpURLConnection openDownloadConnection() throws IOException {
        HttpURLConnection connection = this.dispatcher.urlFactory.open(new URL(this.url));
        connection.setDoInput(true);
        connection.setRequestMethod(REQUEST_METHOD);
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(20000);
        return connection;
    }

    private void reportDownloadStatus(int msgWhat) {
        Message msg = this.dispatcher.handler.obtainMessage(msgWhat);
        DownloadObj obj = new DownloadObj(this, this.url, this.apkFile);
        msg.obj = obj;
        if (msgWhat == 2) {
            obj.setDownloaded(this.downloadedSize);
            obj.setTotal(this.totalSize);
        }
        this.dispatcher.handler.sendMessage(msg);
    }

    private void attachFileRangeHeader(HttpURLConnection connection) {
        if (this.downloadedSize <= 0L) {
            return;
        }
        connection.addRequestProperty(HEADER_RANGE, this.composeRangeValue(this.downloadedSize));
    }

    private String composeRangeValue(long range) {
        StringBuilder sb = new StringBuilder();
        sb.append("bytes=").append(range).append("-");
        return sb.toString();
    }

    private long parseFileSize(HttpURLConnection connection) throws Exception {
        if (this.downloadedSize == 0L) {
            String contentLength = connection.getHeaderField("Content-Length");
            if (contentLength == null) {
                throw new IllegalArgumentException("no content length exist");
            }
            if (contentLength.trim().length() == 0) {
                throw new IllegalAccessException("content length should be set");
            }
            return Long.valueOf(contentLength);
        }
        String contentRange = connection.getHeaderField("Content-Range");
        if (contentRange == null) {
            throw new IllegalArgumentException("no content Range exist");
        }
        if (contentRange.trim().length() == 0) {
            throw new IllegalAccessException("content Range should be set");
        }
        int startIndex = contentRange.indexOf("/");
        return Long.valueOf(contentRange.substring(startIndex + 1, contentRange.length()));
    }

    private void save2File(InputStream is, BufferedOutputStream bos) throws Exception {
        byte[] buffer = new byte[4096];
        int count = -1;
        long lastUpdateTime = System.currentTimeMillis();
        while (this.canDownload() && this.isAlive() && (count = is.read(buffer)) != -1) {
            bos.write(buffer, 0, count);
            this.downloadedSize += (long)count;
            long now = System.currentTimeMillis();
            if (!this.shouldReportProgress(lastUpdateTime, now)) continue;
            this.reportDownloadStatus(2);
            lastUpdateTime = now;
        }
        bos.flush();
        if (this.downloadedSize == this.totalSize) {
            if (this.checkMd5(this.tempFile)) {
                this.handleDownloadSuccessIssue();
            } else {
                this.tempFile.delete();
                this.reportDownloadStatus(4);
            }
        } else if (this.isCanceled()) {
            this.reportDownloadStatus(6);
        } else if (this.isDeleted()) {
            this.tempFile.delete();
            this.reportDownloadStatus(7);
        }
    }

    private boolean canDownload() {
        if (this.downloadedSize == 0L) {
            return true;
        }
        return this.downloadedSize < this.totalSize;
    }

    private boolean shouldReportProgress(long lastUpdateTime, long now) {
        return now - lastUpdateTime > 500L || this.downloadedSize == this.totalSize;
    }

    private void handleDownloadSuccessIssue() {
        this.apkFile = DownloadUtils.createDownloadFormalFile(this.context, this.key);
        DownloadUtils.renameFile(this.tempFile, this.apkFile);
        this.reportDownloadStatus(3);
    }

    private boolean checkMd5(File downloadFile) {
        if (this.md5 == null) {
            return true;
        }
        String fileMd5 = MD5Utils.getFileMD5(downloadFile);
        if (fileMd5 == null) {
            return false;
        }
        return this.md5.equalsIgnoreCase(fileMd5);
    }

    private boolean checkFinish() {
        if (this.checkMd5(this.tempFile)) {
            this.handleDownloadSuccessIssue();
            return true;
        }
        this.downloadedSize = 0L;
        this.tempFile.delete();
        return false;
    }

    private void performHttp416(HttpURLConnection connection) {
        long size = this.getHttpTotalSize(connection);
        if (size < 1L) {
            Log.w((String)TAG, (String)"perform http 416. get Content-Range total size failed.");
            return;
        }
        this.totalSize = size;
        if (this.tempFile.length() > this.totalSize) {
            this.tempFile.delete();
            this.downloadedSize = 0L;
        }
    }

    private long getHttpTotalSize(HttpURLConnection connection) {
        String contentRange = connection.getHeaderField("Content-Range");
        if (null == contentRange) {
            return -1L;
        }
        if (!contentRange.contains(BYTES)) {
            return -1L;
        }
        int index = (contentRange = contentRange.trim()).indexOf("/");
        if (-1 == index || index == contentRange.length() - 1) {
            return -1L;
        }
        String last = contentRange.substring(index + 1);
        if (last.matches(MATCH_CASE)) {
            return -1L;
        }
        return Long.valueOf(last);
    }
}

