/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.clientcommon;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static final int BUFF_SIZE = 0x100000;

    public static void zipFiles(Collection<File> resFileList, File zipFile) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 0x100000));
        for (File resFile : resFileList) {
            ZipUtils.zipFile(resFile, zipOut, "");
        }
        zipOut.close();
    }

    public static void zipFiles(Collection<File> resFileList, File zipFile, String comment) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 0x100000));
        for (File resFile : resFileList) {
            ZipUtils.zipFile(resFile, zipOut, "");
        }
        zipOut.setComment(comment);
        zipOut.close();
    }

    public static void upZipFile(File zipFile, String folderPath) throws IOException {
        File desDir = new File(folderPath);
        if (!desDir.exists()) {
            desDir.mkdirs();
        }
        ZipFile zf = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            int realLength;
            ZipEntry entry = entries.nextElement();
            InputStream in = zf.getInputStream(entry);
            String str = folderPath + File.separator + entry.getName();
            File desFile = new File(str = new String(str.getBytes("8859_1"), "GB2312"));
            if (!desFile.exists()) {
                File fileParentDir = desFile.getParentFile();
                if (!fileParentDir.exists()) {
                    fileParentDir.mkdirs();
                }
                desFile.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(desFile);
            byte[] buffer = new byte[0x100000];
            while ((realLength = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, realLength);
            }
            in.close();
            ((OutputStream)out).close();
        }
    }

    public static ArrayList<File> upZipSelectedFile(File zipFile, String folderPath, String nameContains) throws IOException {
        ArrayList<File> fileList = new ArrayList<File>();
        File desDir = new File(folderPath);
        if (!desDir.exists()) {
            desDir.mkdir();
        }
        ZipFile zf = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            int realLength;
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().contains(nameContains)) continue;
            InputStream in = zf.getInputStream(entry);
            String str = folderPath + File.separator + entry.getName();
            File desFile = new File(str = new String(str.getBytes("8859_1"), "GB2312"));
            if (!desFile.exists()) {
                File fileParentDir = desFile.getParentFile();
                if (!fileParentDir.exists()) {
                    fileParentDir.mkdirs();
                }
                desFile.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(desFile);
            byte[] buffer = new byte[0x100000];
            while ((realLength = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, realLength);
            }
            in.close();
            ((OutputStream)out).close();
            fileList.add(desFile);
        }
        return fileList;
    }

    public static ArrayList<String> getEntriesNames(File zipFile) throws IOException {
        ArrayList<String> entryNames = new ArrayList<String>();
        Enumeration<?> entries = ZipUtils.getEntriesEnumeration(zipFile);
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)entries.nextElement();
            entryNames.add(new String(ZipUtils.getEntryName(entry).getBytes("GB2312"), "8859_1"));
        }
        return entryNames;
    }

    public static Enumeration<?> getEntriesEnumeration(File zipFile) throws IOException {
        ZipFile zf = new ZipFile(zipFile);
        return zf.entries();
    }

    public static String getEntryComment(ZipEntry entry) throws UnsupportedEncodingException {
        return new String(entry.getComment().getBytes("GB2312"), "8859_1");
    }

    public static String getEntryName(ZipEntry entry) throws UnsupportedEncodingException {
        return new String(entry.getName().getBytes("GB2312"), "8859_1");
    }

    private static void zipFile(File resFile, ZipOutputStream zipOut, String rootPath) throws IOException {
        rootPath = rootPath + (rootPath.trim().length() == 0 ? "" : File.separator) + resFile.getName();
        rootPath = new String(rootPath.getBytes("8859_1"), "GB2312");
        if (resFile.isDirectory()) {
            File[] fileList;
            for (File file : fileList = resFile.listFiles()) {
                ZipUtils.zipFile(file, zipOut, rootPath);
            }
        } else {
            int realLength;
            byte[] buffer = new byte[0x100000];
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(resFile), 0x100000);
            zipOut.putNextEntry(new ZipEntry(rootPath));
            while ((realLength = in.read(buffer)) != -1) {
                zipOut.write(buffer, 0, realLength);
            }
            in.close();
            zipOut.flush();
            zipOut.closeEntry();
        }
    }
}

