/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.clientcommon;

import android.content.Context;
import com.shouzhan.clientcommon.MD5Utils;
import com.shouzhan.clientcommon.Prefs;
import java.util.Random;

public class ServerTimeUtils {
    private static final String SEEDS = "abcdefghijklmnopqrstuvwxyz0123456789";
    private static final int SALT_LENGTH = 6;
    public static final String ITEM_CUSTOM_VOD_REMOTE_TIMESTAMP = "item_custom_vod_remote_timestamp";
    public static final String ITEM_CUSTOM_VOD_LOCAL_TIMESTAMP = "item_custom_vod_local_timestamp";

    public static void saveServerTime(Context context, long remoteTS) {
        Prefs prefs = Prefs.getInstance(context);
        prefs.save(3, ITEM_CUSTOM_VOD_REMOTE_TIMESTAMP, remoteTS);
        prefs.save(3, ITEM_CUSTOM_VOD_LOCAL_TIMESTAMP, System.currentTimeMillis());
    }

    public static String genSalt() {
        StringBuilder ret = new StringBuilder(6);
        Random rand = new Random(System.currentTimeMillis());
        for (int i = 0; i < 6; ++i) {
            int position = rand.nextInt(SEEDS.length());
            ret.append(SEEDS.charAt(position));
        }
        return ret.toString();
    }

    public static long getCustomVodRequestTimestamp(Context context) {
        long remoteTimestamp = (Long)Prefs.getInstance(context).get(3, ITEM_CUSTOM_VOD_REMOTE_TIMESTAMP, -1L);
        if (remoteTimestamp == -1L) {
            return System.currentTimeMillis();
        }
        long localTimestamp = (Long)Prefs.getInstance(context).get(3, ITEM_CUSTOM_VOD_LOCAL_TIMESTAMP, -1L);
        if (localTimestamp == -1L) {
            return System.currentTimeMillis();
        }
        long currentTS = System.currentTimeMillis();
        if (currentTS < localTimestamp) {
            return currentTS;
        }
        return ServerTimeUtils.calcCurrentRemoteTimeStamp(remoteTimestamp, localTimestamp, currentTS);
    }

    private static long calcCurrentRemoteTimeStamp(long remoteTimestamp, long localTimestamp, long currentTS) {
        long timeSpan = currentTS - localTimestamp;
        return remoteTimestamp + timeSpan;
    }

    public static String calcCheckSum(String salt, long time, String key) {
        StringBuilder sb = new StringBuilder().append(salt).append(key).append(time);
        return MD5Utils.getStringMD5(sb.toString());
    }

    public static long getCurrentTime(Context context) {
        return ServerTimeUtils.getCustomVodRequestTimestamp(context);
    }

    public static boolean isTimeCalibration(Context context) {
        long localTimestamp;
        boolean isCalibration = true;
        Prefs prefs = Prefs.getInstance(context);
        long remoteTimestamp = (Long)prefs.get(3, ITEM_CUSTOM_VOD_REMOTE_TIMESTAMP, -1L);
        if (remoteTimestamp <= 0L) {
            isCalibration = false;
        }
        if ((localTimestamp = ((Long)prefs.get(3, ITEM_CUSTOM_VOD_LOCAL_TIMESTAMP, -1L)).longValue()) <= 0L) {
            isCalibration = false;
        }
        return isCalibration;
    }

    public static void cleanCalibrationTime(Context context) {
        Prefs prefs = Prefs.getInstance(context);
        prefs.save(3, ITEM_CUSTOM_VOD_REMOTE_TIMESTAMP, -1L);
        prefs.save(3, ITEM_CUSTOM_VOD_LOCAL_TIMESTAMP, -1L);
    }
}

