/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.clientcommon;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class PermissionUtils {
    public static final String[] STORAGE_PERMISSION = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
    public static final String[] CAMERA_PERMISSION = new String[]{"android.permission.CAMERA"};
    public static final String[] LOC_PERMISSIONS = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.READ_PHONE_STATE"};
    public static final String[] CALL_PHONE_PERMISSION = new String[]{"android.permission.CALL_PHONE"};
    public static final String[] READ_PHONE_STATE_PERMISSION = new String[]{"android.permission.READ_PHONE_STATE"};
    public static final String[] SEND_SMS_PERMISSION = new String[]{"android.permission.SEND_SMS"};
    public static final String[] NETWORK_PERMISSIONS = new String[]{"android.permission.ACCESS_NETWORK_STATE", "android.permission.ACCESS_WIFI_STATE"};
    public static final int PERMISSION_CAMERA_REQUEST_CODE = 1;
    public static final int PERMISSION_STORAGE_REQUEST_CODE = 2;
    public static final int PERMISSION_LOC_REQUEST_CODE = 3;
    public static final int PERMISSION_CALL_PHONE_REQUEST_CODE = 4;
    public static final int PERMISSION_SEND_SMS_REQUEST_CODE = 5;
    public static final int PERMISSION_READ_PHONE_REQUEST_CODE = 6;
    private static int mRequestCode = -1;
    private static WeakReference<OnPermissionListener> mOnPermissionListener = null;

    @TargetApi(value=23)
    public static void requestPermissionsAgain(@NonNull Context context, @NonNull String[] permissions, @NonNull int requestCode) {
        if (!(context instanceof Activity)) {
            throw new IllegalArgumentException("Context must be an Activity");
        }
        ((Activity)context).requestPermissions(permissions, requestCode);
    }

    public static void requestPermissions(@NonNull Context context, @NonNull int requestCode, @NonNull String[] permissions, OnPermissionListener listener) {
        mRequestCode = requestCode;
        mOnPermissionListener = new WeakReference<OnPermissionListener>(listener);
        String[] deniedPermissions = PermissionUtils.getDeniedPermissions(context, permissions);
        if (deniedPermissions.length > 0 && Build.VERSION.SDK_INT >= 23) {
            PermissionUtils.requestPermissionsAgain(context, permissions, requestCode);
        } else if (mOnPermissionListener.get() != null) {
            ((OnPermissionListener)mOnPermissionListener.get()).onPermissionGranted();
        }
    }

    public static void onRequestPermissionsResult(@NonNull Activity context, int requestCode, @NonNull String[] permissions, int[] grantResults) {
        if (mRequestCode != -1 && requestCode == mRequestCode && mOnPermissionListener.get() != null) {
            String[] deniedPermissions = PermissionUtils.getDeniedPermissions((Context)context, permissions);
            if (deniedPermissions.length > 0) {
                boolean alwaysDenied = PermissionUtils.hasAlwaysDeniedPermission((Context)context, permissions);
                ((OnPermissionListener)mOnPermissionListener.get()).onPermissionDenied(deniedPermissions, alwaysDenied);
            } else {
                ((OnPermissionListener)mOnPermissionListener.get()).onPermissionGranted();
            }
        }
    }

    private static String[] getDeniedPermissions(@NonNull Context context, @NonNull String[] permissions) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)permission2) != -1) continue;
            deniedPermissions.add(permission2);
        }
        return deniedPermissions.toArray(new String[deniedPermissions.size()]);
    }

    private static boolean hasAlwaysDeniedPermission(@NonNull Context context, String ... deniedPermissions) {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        for (String permission2 : deniedPermissions) {
            boolean rationale = ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)context), (String)permission2);
            if (rationale) continue;
            return true;
        }
        return false;
    }

    public static boolean checkSelfPermission(@NonNull Context context, @NonNull String permission2) {
        return ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
    }

    public static boolean checkSelfPermissions(Context context, String ... permissions) {
        for (String permission2 : permissions) {
            if (PermissionUtils.checkSelfPermission(context, permission2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCameraEnable() {
        boolean isCanUse = true;
        Camera mCamera = null;
        try {
            mCamera = Camera.open();
            Camera.Parameters mParameters = mCamera.getParameters();
            mCamera.setParameters(mParameters);
        }
        catch (Exception e) {
            isCanUse = false;
        }
        if (mCamera != null) {
            try {
                mCamera.release();
            }
            catch (Exception e) {
                e.printStackTrace();
                return isCanUse;
            }
        }
        return isCanUse;
    }

    public static void skipAppSettingPage(Context mContext) {
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        if (Build.VERSION.SDK_INT >= 9) {
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.fromParts((String)"package", (String)mContext.getPackageName(), null));
        } else {
            intent.setAction("android.intent.action.VIEW");
            intent.setClassName("com.android.settings", "com.android.settings.InstalledAppDetails");
            intent.putExtra("com.android.settings.ApplicationPkgName", mContext.getPackageName());
        }
        mContext.startActivity(intent);
    }

    public static interface OnPermissionListener {
        public void onPermissionGranted();

        public void onPermissionDenied(String[] var1, boolean var2);
    }
}

