/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.clientcommon;

import com.shouzhan.clientcommon.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;

public class MD5Utils {
    private static final String DIGEST_ALGORITHM_MD5 = "MD5";
    private static final String[] HEX_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5(File file) {
        String string;
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream fis = null;
        FileChannel fch = null;
        try {
            fis = new FileInputStream(file);
            fch = fis.getChannel();
            MappedByteBuffer byteBuffer = fch.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM_MD5);
            messageDigest.update(byteBuffer);
            string = MD5Utils.byteArrayToHexString(messageDigest.digest());
            CommonUtils.silentClose(fch);
        }
        catch (Exception e) {
            String string2 = null;
            return string2;
        }
        finally {
            CommonUtils.silentClose(fch);
            CommonUtils.silentClose(fis);
        }
        CommonUtils.silentClose(fis);
        return string;
    }

    public static String getStringMD5(String src) {
        if (CommonUtils.isStringInvalid(src)) {
            return null;
        }
        String result = null;
        try {
            result = new String(src);
            result = MD5Utils.byteArrayToHexString(MessageDigest.getInstance(DIGEST_ALGORITHM_MD5).digest(result.getBytes()));
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return result.toLowerCase();
    }

    public static String byteArrayToHexString(byte[] digest) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            result.append(MD5Utils.byteToHexString(digest[i]));
        }
        return result.toString();
    }

    public static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return HEX_DIGITS[d1] + HEX_DIGITS[d2];
    }

    public static byte[] stringToByte(String hexString) {
        int len = hexString.length() / 2;
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = Integer.valueOf(hexString.substring(2 * i, 2 * i + 2), 16).byteValue();
        }
        return result;
    }
}

