/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.clientcommon;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.Bundle;
import com.shouzhan.clientcommon.CommonUtils;
import com.shouzhan.clientcommon.RSAUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.zip.GZIPInputStream;

public class InternalUtils {
    public static final int CLIENT_ERROR_CODE = 400;
    public static final int LOGIN_ACCOUNT_IS_USED_CODE = 406;
    public static final int LOGIN_ACCOUNT_NOT_FOUND_CODE = 404;
    public static final int NETWORK_FAIL = 0;
    public static final String BUSINESS_FAIL = "FAIL";
    public static final int SERVER_ERROR_CODE = 500;
    public static final int RPC_ERROR = 501;
    public static final int DEFAULT_HTTP_RETRY_TIMES = 3;
    public static final String UTF_8 = "UTF-8";
    public static final String TEST_RANDOM_STRING = "123456";
    public static final String SIGN_RANDOM_STRING = "t5B6I@N&JaLVozpX";
    public static final int DEFAULT_READ_TIMEOUT = 20000;
    public static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    public static final int DEFAULT_ANDROID_PLATFORM = 1;
    public static final int MD5 = 1;
    public static final int RSA = 2;
    public static final int TEST = 0;
    public static final int BETA = 1;
    public static final int SIGN = 2;
    public static final String REQUEST_METHOD_GET = "GET";
    public static final String REQUEST_METHOD_POST = "POST";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_ACCEPT_CODING = "Accept-Encoding";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_ACCESS_TOKEN = "access-token";
    public static final String HEADER_APP_VERSION = "app-version";
    public static final String PARAM_ACCESS_TOKEN = "accessToken";
    public static final String PARAM_SIGN_TYPE = "signType";
    public static final String PARAM_SIGN = "sign";
    public static final String STRING_GZIP = "gzip";
    public static final String STRING_CONTENT_TYPE = "application/json";
    public static final String ACCEPT_CODING = "gzip,deflate,sdch";
    public static final String CHANNEL_NAME = "UMENG_CHANNEL";
    public static final String PROJECT_NAME = "PROJECT_NAME";
    static String clientName;
    static Object clientNameLock;
    static String clientPackage;
    static Object clientPackageLock;
    static String clientVersion;
    static Object clientVersionLock;
    static String channel;
    static Object channelLock;
    static String project;
    static Object projectLock;
    static int clientCode;
    static Object clientCodeLock;
    static String privateKey;
    static Object privateKeyObject;
    static String host;
    static int server;

    public static String getAcceptCoding() {
        return ACCEPT_CODING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obtainPrivateKey(Context context) {
        if (privateKey == null) {
            Object object = privateKeyObject;
            synchronized (object) {
                if (privateKey == null) {
                    try {
                        InputStream inputStream = InternalUtils.obtainPrivateKeyInputStream(context);
                        privateKey = RSAUtils.readKey(inputStream);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return privateKey;
    }

    private static InputStream obtainPrivateKeyInputStream(Context context) throws Exception {
        InputStream inputStream;
        AssetManager assetManager = context.getResources().getAssets();
        switch (InternalUtils.getServer()) {
            case 0: {
                inputStream = assetManager.open("rsa_private_key_pkcs8_test.pem");
                break;
            }
            case 1: {
                inputStream = null;
                break;
            }
            case 2: {
                inputStream = assetManager.open("rsa_private_key_pkcs8_sign.pem");
                break;
            }
            default: {
                inputStream = null;
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obtainClientName(Context context) {
        if (clientName == null) {
            Object object = clientNameLock;
            synchronized (object) {
                if (clientName == null) {
                    clientName = InternalUtils.getClientName(context);
                }
            }
        }
        return clientName;
    }

    public static String getClientName(Context context) {
        PackageInfo pInfo = null;
        try {
            PackageManager pm = context.getPackageManager();
            pInfo = pm.getPackageInfo(context.getPackageName(), 0);
            String clientName = pm.getApplicationLabel(pInfo.applicationInfo).toString();
            return URLEncoder.encode(clientName.trim(), UTF_8);
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obtainClientPackage(Context context) {
        if (clientPackage == null) {
            Object object = clientPackageLock;
            synchronized (object) {
                if (clientPackage == null) {
                    clientPackage = context.getPackageName();
                }
            }
        }
        return clientPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obtainClientVersion(Context context) {
        if (clientVersion == null) {
            Object object = clientVersionLock;
            synchronized (object) {
                if (clientVersion == null) {
                    clientVersion = InternalUtils.getClientVersion(context);
                }
            }
        }
        return clientVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int obtainClientCode(Context context) {
        if (clientCode == -1) {
            Object object = clientCodeLock;
            synchronized (object) {
                if (clientCode == -1) {
                    clientCode = InternalUtils.getClientCode(context);
                }
            }
        }
        return clientCode;
    }

    public static String getClientVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)InternalUtils.obtainClientPackage((Context)context), (int)0).versionName;
        }
        catch (Exception e) {
            return "";
        }
    }

    private static int getClientCode(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)InternalUtils.obtainClientPackage((Context)context), (int)0).versionCode;
        }
        catch (Exception e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obtainChannel(Context context) {
        if (channel == null) {
            Object object = channelLock;
            synchronized (object) {
                if (channel == null) {
                    channel = InternalUtils.getChannel(context);
                }
            }
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obtainProjectName(Context context) {
        if (project == null) {
            Object object = projectLock;
            synchronized (object) {
                if (project == null) {
                    project = InternalUtils.getProjectName(context);
                }
            }
        }
        return project;
    }

    private static String getProjectName(Context context) {
        try {
            Bundle metaData = context.getPackageManager().getPackageInfo((String)InternalUtils.obtainClientPackage((Context)context), (int)128).applicationInfo.metaData;
            if (metaData == null) {
                return "";
            }
            Object obj = metaData.get(PROJECT_NAME);
            if (obj == null) {
                return "";
            }
            return obj.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String getChannel(Context context) {
        try {
            Bundle metaData = context.getPackageManager().getPackageInfo((String)InternalUtils.obtainClientPackage((Context)context), (int)128).applicationInfo.metaData;
            if (metaData == null) {
                return "";
            }
            Object obj = metaData.get(CHANNEL_NAME);
            if (obj == null) {
                return "";
            }
            return obj.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void setChannel(String mChannel) {
        if (CommonUtils.isStringInvalid(mChannel)) {
            return;
        }
        channel = mChannel;
    }

    public static void setHost(String mHost) {
        host = mHost;
    }

    public static String getHost() {
        return host;
    }

    public static void setServer(int mServer) {
        server = mServer;
    }

    public static int getServer() {
        return server;
    }

    public static String constructUA(String appName, String appPkg, String appVersion, String channel, String platform, String system, String devModel) {
        return new StringBuffer().append(appName).append(",").append(appPkg).append(",").append(appVersion).append(",").append(channel).append(",").append(platform).append(",").append(system).append(",").append(devModel).toString();
    }

    public static String constructProject(String projectName, String channel) {
        return new StringBuffer().append(projectName).append("-").append(channel).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File cacheZipStream(Context context, InputStream is) throws IOException {
        File f = null;
        FileOutputStream fos = null;
        GZIPInputStream gZis = null;
        try {
            f = new File(context.getCacheDir() + File.separator + "zipCache" + File.separator + System.currentTimeMillis());
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            f.createNewFile();
            gZis = new GZIPInputStream(is);
            fos = new FileOutputStream(f);
            byte[] buffer = new byte[4096];
            int number = -1;
            while ((number = gZis.read(buffer)) != -1) {
                fos.write(buffer, 0, number);
            }
            fos.flush();
        }
        catch (Throwable throwable) {
            CommonUtils.silentClose(fos);
            throw throwable;
        }
        CommonUtils.silentClose(fos);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream unZIP(InputStream in) throws IOException {
        ByteArrayInputStream out = null;
        GZIPInputStream gZis = null;
        ByteArrayOutputStream byteStream = null;
        try {
            int number;
            gZis = new GZIPInputStream(in);
            byteStream = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((number = gZis.read(buf)) != -1) {
                byteStream.write(buf, 0, number);
            }
            out = new ByteArrayInputStream(byteStream.toByteArray());
        }
        catch (Throwable throwable) {
            CommonUtils.silentClose(gZis);
            CommonUtils.silentClose(byteStream);
            gZis = null;
            System.gc();
            throw throwable;
        }
        CommonUtils.silentClose(gZis);
        CommonUtils.silentClose(byteStream);
        gZis = null;
        System.gc();
        return out;
    }

    public static String extractHost(String url) {
        if (url == null) {
            return null;
        }
        int indexOfDSlash = url.indexOf("//");
        if (indexOfDSlash == -1) {
            return null;
        }
        int indexOfSlash = (url = url.substring(indexOfDSlash + 2)).indexOf("/");
        if (indexOfSlash == -1) {
            return null;
        }
        return url.substring(0, indexOfSlash);
    }

    static {
        clientNameLock = new Object();
        clientPackageLock = new Object();
        clientVersionLock = new Object();
        channelLock = new Object();
        projectLock = new Object();
        clientCode = -1;
        clientCodeLock = new Object();
        privateKeyObject = new Object();
    }
}

