/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.clientcommon;

import android.content.Context;
import com.shouzhan.clientcommon.CommonUtils;
import com.shouzhan.clientcommon.FileCacheUtils;
import com.shouzhan.download.DownloadUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import okhttp3.OkHttpClient;
import okhttp3.OkUrlFactory;

public class FileCacheTask {
    private static final String TAG = "FileCacheTask";
    private static final String REQUEST_METHOD = "GET";
    private static final String HEADER_RANGE = "RANGE";
    private Context context;
    private String url;
    private String dirName;
    private OkUrlFactory urlFactory;
    private boolean supportBreakPointResume;
    private long downloadedSize;
    private long totalSize;
    private boolean alive;
    private int retryTimes;
    private File tempFile;
    private File cacheFile;

    public FileCacheTask(Context context, String url, String dirName) {
        this(context, url, dirName, false);
    }

    public FileCacheTask(Context context, String url, String dirName, boolean supportBreakPointResume) {
        this.context = context;
        this.url = url;
        this.dirName = dirName;
        this.supportBreakPointResume = supportBreakPointResume;
        OkHttpClient.Builder mBuilder = new OkHttpClient.Builder();
        this.urlFactory = new OkUrlFactory(mBuilder.build());
        this.downloadedSize = 0L;
        this.totalSize = 0L;
        this.retryTimes = 2;
        this.alive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute() {
        HttpURLConnection connection = null;
        InputStream is = null;
        BufferedOutputStream bos = null;
        String retPath = null;
        if (this.url == null) return retPath;
        if (this.url.trim().length() <= 0) {
            return retPath;
        }
        int i = 0;
        while (this.alive) {
            block24: {
                block23: {
                    String string;
                    block22: {
                        String string2;
                        block21: {
                            block20: {
                                String string3;
                                block19: {
                                    if (is != null) return retPath;
                                    if (i >= this.retryTimes) return retPath;
                                    try {
                                        if (FileCacheUtils.isFileCached(this.context, this.dirName, this.url)) {
                                            string3 = retPath = FileCacheUtils.getCacheFilePath(this.context, this.dirName, this.url);
                                            CommonUtils.silentClose(bos);
                                            break block19;
                                        }
                                        connection = this.openDownloadConnection();
                                        this.tempFile = new File(FileCacheUtils.getTempCacheFilePath(this.context, this.dirName, this.url));
                                        if (!this.supportBreakPointResume && this.tempFile.exists()) {
                                            this.tempFile.delete();
                                        }
                                        this.downloadedSize = this.tempFile.length();
                                        bos = new BufferedOutputStream(new FileOutputStream(this.tempFile, this.downloadedSize > 0L));
                                        this.attachFileRangeHeader(connection);
                                        int statusCode = connection.getResponseCode();
                                        if (statusCode != 200 && statusCode != 206) {
                                            CommonUtils.silentClose(bos);
                                            break block20;
                                        }
                                        if (!this.alive) {
                                            string2 = retPath = null;
                                            CommonUtils.silentClose(bos);
                                            break block21;
                                        }
                                        this.totalSize = this.parseFileSize(connection);
                                        if (this.totalSize == this.downloadedSize) {
                                            string = retPath = FileCacheUtils.getCacheFilePath(this.context, this.dirName, this.url);
                                            CommonUtils.silentClose(bos);
                                            break block22;
                                        }
                                        is = connection.getInputStream();
                                        retPath = this.save2File(is, bos);
                                        CommonUtils.silentClose(bos);
                                        break block23;
                                    }
                                    catch (Exception e) {
                                        retPath = null;
                                        break block24;
                                    }
                                }
                                CommonUtils.silentClose(is);
                                CommonUtils.closeConnection(connection);
                                if (retPath != null) return string3;
                                if (this.supportBreakPointResume) return string3;
                                this.deleteCacheFileOnError();
                                return string3;
                            }
                            CommonUtils.silentClose(is);
                            CommonUtils.closeConnection(connection);
                            if (retPath == null && !this.supportBreakPointResume) {
                                this.deleteCacheFileOnError();
                            }
                            break block24;
                        }
                        CommonUtils.silentClose(is);
                        CommonUtils.closeConnection(connection);
                        if (retPath != null) return string2;
                        if (this.supportBreakPointResume) return string2;
                        this.deleteCacheFileOnError();
                        return string2;
                    }
                    CommonUtils.silentClose(is);
                    CommonUtils.closeConnection(connection);
                    if (retPath != null) return string;
                    if (this.supportBreakPointResume) return string;
                    this.deleteCacheFileOnError();
                    return string;
                }
                CommonUtils.silentClose(is);
                CommonUtils.closeConnection(connection);
                if (retPath == null && !this.supportBreakPointResume) {
                    this.deleteCacheFileOnError();
                }
                break block24;
                finally {
                    CommonUtils.silentClose(bos);
                    CommonUtils.silentClose(is);
                    CommonUtils.closeConnection(connection);
                    if (retPath == null && !this.supportBreakPointResume) {
                        this.deleteCacheFileOnError();
                    }
                }
            }
            ++i;
        }
        return retPath;
    }

    public void cancel() {
        this.alive = false;
    }

    private HttpURLConnection openDownloadConnection() throws IOException {
        HttpURLConnection connection = this.urlFactory.open(new URL(this.url));
        connection.setDoInput(true);
        connection.setRequestMethod(REQUEST_METHOD);
        return connection;
    }

    private void attachFileRangeHeader(HttpURLConnection connection) {
        if (!this.supportBreakPointResume) {
            return;
        }
        connection.addRequestProperty(HEADER_RANGE, this.composeRangeValue(this.downloadedSize));
    }

    private String composeRangeValue(long range) {
        StringBuilder sb = new StringBuilder();
        sb.append("bytes=").append(range).append("-");
        return sb.toString();
    }

    private void deleteCacheFileOnError() {
        this.tempFile.delete();
    }

    private long parseFileSize(HttpURLConnection connection) throws Exception {
        if (this.downloadedSize == 0L) {
            String contentLength = connection.getHeaderField("Content-Length");
            if (contentLength == null) {
                throw new IllegalArgumentException("no content length exist");
            }
            if (contentLength.trim().length() == 0) {
                throw new IllegalAccessException("content length should be set");
            }
            return Long.valueOf(contentLength);
        }
        String contentRange = connection.getHeaderField("Content-Range");
        if (contentRange == null) {
            throw new IllegalArgumentException("no content Range exist");
        }
        if (contentRange.trim().length() == 0) {
            throw new IllegalAccessException("content Range should be set");
        }
        int startIndex = contentRange.indexOf("/");
        return Long.valueOf(contentRange.substring(startIndex + 1, contentRange.length()));
    }

    private String save2File(InputStream is, BufferedOutputStream bos) throws Exception {
        byte[] buffer = new byte[4096];
        int count = -1;
        while (this.alive && (count = is.read(buffer)) != -1) {
            bos.write(buffer, 0, count);
            this.downloadedSize += (long)count;
        }
        if (this.downloadedSize == this.totalSize) {
            this.cacheFile = new File(FileCacheUtils.getCacheFilePath(this.context, this.dirName, this.url));
            DownloadUtils.renameFile(this.tempFile, this.cacheFile);
            return this.cacheFile.getAbsolutePath();
        }
        if (!this.alive && !this.supportBreakPointResume) {
            return null;
        }
        return null;
    }
}

