/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.clientcommon;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.shouzhan.clientcommon.CommonRegex;
import com.shouzhan.clientcommon.InternalUtils;
import com.shouzhan.upload.FileUploadTask;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonUtils {
    private static final String TAG = "CommonUtils";
    private static final Pattern PATTERN = Pattern.compile("\t|\r|\n|\\s*");
    private static final String SCHEMA_HTTP = "http://";
    private static final String SCHEMA_HTTPS = "https://";
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private static final String SLASH = "/";
    private static final String POINT = ".";

    public static void silentClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
    }

    public static void closeConnection(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }

    public static String formatSdkLevel() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    public static String getAppName(Context context) {
        return InternalUtils.obtainClientName(context);
    }

    public static String getAppVersionName(Context context) {
        return InternalUtils.obtainClientVersion(context);
    }

    public static int getAppVersionCode(Context context) {
        return InternalUtils.obtainClientCode(context);
    }

    public static String getChannel(Context context) {
        return InternalUtils.obtainChannel(context);
    }

    public static String getAppPackageName(Context context) {
        return InternalUtils.obtainClientPackage(context);
    }

    @SuppressLint(value={"MissingPermission"})
    public static int getDevNetworkType(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return -1;
        }
        NetworkInfo ni = cm.getActiveNetworkInfo();
        if (ni == null) {
            return -1;
        }
        int type = ni.getType();
        if (type == 1) {
            type = 5;
        } else if (type == 0) {
            int subType = ni.getSubtype();
            if (subType == 4 || subType == 1 || subType == 2) {
                type = 1;
            } else if (subType == 3 || subType == 8 || subType == 6 || subType == 5 || subType == 12) {
                type = 2;
            } else if (subType == 13) {
                type = 3;
            }
        }
        return type;
    }

    public static boolean isNetworkActive(int networkType) {
        return networkType != -1;
    }

    public static boolean isNetworkActive(Context context) {
        return CommonUtils.isNetworkActive(CommonUtils.getDevNetworkType(context));
    }

    public static String getDevModel() {
        return Build.MODEL.toLowerCase();
    }

    public static String fixRequestUrl(String host, String action) {
        if (CommonUtils.isStringInvalid(action)) {
            return null;
        }
        if ((action = action.trim()).contains(PROTOCOL_HTTP)) {
            return action;
        }
        if (CommonUtils.isStringInvalid(host)) {
            return null;
        }
        if (!action.startsWith(SLASH)) {
            return SCHEMA_HTTP + host + SLASH + action;
        }
        return SCHEMA_HTTP + host + action;
    }

    public static String fixRequestHttpsUrl(String host, String action) {
        if (host.equals("apppaycloud-test.wechatpark.com")) {
            return CommonUtils.fixRequestUrl(host, action);
        }
        if (CommonUtils.isStringInvalid(action)) {
            return null;
        }
        if ((action = action.trim()).contains(PROTOCOL_HTTPS)) {
            return action;
        }
        if (CommonUtils.isStringInvalid(host)) {
            return null;
        }
        if (!action.startsWith(SLASH)) {
            return SCHEMA_HTTPS + host + SLASH + action;
        }
        return SCHEMA_HTTPS + host + action;
    }

    public static String fixImageRequestUrl(String ignoreHost, String ip, String url) {
        if (CommonUtils.isStringInvalid(ip)) {
            return url;
        }
        if (CommonUtils.isStringInvalid(url)) {
            return null;
        }
        if ((url = url.trim()).startsWith(PROTOCOL_HTTP)) {
            int sec;
            int start = url.indexOf("://") + "://".length();
            String host = url.substring(start, sec = url.indexOf(SLASH, start));
            if (!host.endsWith(ignoreHost)) {
                return url;
            }
            return url.substring(0, start) + ip + url.substring(sec, url.length());
        }
        if (!url.startsWith(SLASH)) {
            int start = url.indexOf(SLASH);
            if (url.indexOf(POINT) < start) {
                String host = url.substring(0, start);
                if (!host.endsWith(ignoreHost)) {
                    return SCHEMA_HTTP + url;
                }
                return SCHEMA_HTTP + ip + url.substring(start, url.length());
            }
            return SCHEMA_HTTP + ip + SLASH + url;
        }
        int start = url.indexOf(SLASH, 1);
        if (url.indexOf(POINT) < start) {
            String host = url.substring(1, start);
            if (!host.endsWith(ignoreHost)) {
                return SCHEMA_HTTP + url.substring(1, url.length());
            }
            return SCHEMA_HTTP + ip + url.substring(start, url.length());
        }
        return SCHEMA_HTTP + ip + url;
    }

    public static boolean isStringInvalid(String str) {
        return str == null || str.trim().length() <= 0;
    }

    public static String readStream(InputStream is) {
        try {
            return CommonUtils.readStream(is, false);
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStream(InputStream is, boolean closeIt) throws Exception {
        StringBuilder sb;
        BufferedReader br;
        block7: {
            br = null;
            sb = new StringBuilder();
            try {
                String line;
                br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
                if (!closeIt) break block7;
            }
            catch (Exception e) {
                block8: {
                    try {
                        sb.setLength(0);
                        if (!closeIt) {
                            throw e;
                        }
                        if (!closeIt) break block8;
                    }
                    catch (Throwable throwable) {
                        if (closeIt) {
                            CommonUtils.silentClose(is);
                        }
                        CommonUtils.silentClose(br);
                        throw throwable;
                    }
                    CommonUtils.silentClose(is);
                }
                CommonUtils.silentClose(br);
            }
            CommonUtils.silentClose(is);
        }
        CommonUtils.silentClose(br);
        return sb.toString();
    }

    public static String parse2string(InputStream is) throws IOException {
        if (null == is) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(is);
        StringBuilder builder = new StringBuilder();
        int len = 0;
        char[] buf = new char[4096];
        while (-1 != (len = reader.read(buf))) {
            if (len > 0) {
                builder.append(buf, 0, len);
            }
            Arrays.fill(buf, '\u0000');
        }
        return builder.toString();
    }

    public static String encodeUrlSegment(String segment) {
        try {
            return URLEncoder.encode(segment, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return segment;
        }
    }

    public static int parseInt(String value) {
        if (CommonUtils.isStringInvalid(value)) {
            return -1;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static long parseLong(String value) {
        if (CommonUtils.isStringInvalid(value)) {
            return -1L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static SpannableStringBuilder genHightlightText(String originalText, int startIndex, int length, int highLightColor) {
        SpannableStringBuilder style = new SpannableStringBuilder((CharSequence)originalText);
        style.setSpan((Object)new ForegroundColorSpan(highLightColor), startIndex, startIndex + length, 18);
        return style;
    }

    public static String formatText(String text) {
        if (CommonUtils.isStringInvalid(text)) {
            return "";
        }
        return text.trim();
    }

    public static CharSequence formatText(CharSequence charSequence) {
        if (charSequence == null) {
            return "";
        }
        return charSequence;
    }

    public static int convertBoolean2Int(boolean b) {
        return b ? 1 : 0;
    }

    public static boolean convertInt2Boolean(int i) {
        return i == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String exec(String[] args) {
        String result;
        block11: {
            result = "";
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            Process process = null;
            InputStream errIs = null;
            InputStream inIs = null;
            try {
                int read;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                process = processBuilder.start();
                errIs = process.getErrorStream();
                while ((read = errIs.read()) != -1) {
                    baos.write(read);
                }
                baos.write(10);
                inIs = process.getInputStream();
                while ((read = inIs.read()) != -1) {
                    baos.write(read);
                }
                byte[] data = baos.toByteArray();
                result = new String(data);
                CommonUtils.silentClose(errIs);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block11;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                CommonUtils.silentClose(errIs);
                CommonUtils.silentClose(inIs);
                if (process != null) {
                    process.destroy();
                }
            }
            CommonUtils.silentClose(inIs);
            if (process != null) {
                process.destroy();
            }
        }
        return result;
    }

    public static String trim(String text) {
        if (null != text) {
            return text.trim();
        }
        return null;
    }

    public static String dumpInputStream(InputStream is) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(is);
        char[] buf = new char[4096];
        int len = 0;
        while (-1 != (len = reader.read(buf))) {
            builder.append(buf, 0, len);
            Arrays.fill(buf, '\u0000');
        }
        return builder.toString();
    }

    public static <T> String dumpObject(T target) {
        if (null == target) {
            return "null";
        }
        return target.toString();
    }

    public static <T> String dumpList(List<T> list) {
        StringBuilder builder = new StringBuilder();
        if (null == list) {
            builder.append("null");
        } else {
            Object obj = null;
            builder.append("{size: " + list.size());
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                obj = list.get(i);
                builder.append(", [" + i + "]: {");
                if (null == obj) {
                    builder.append("null");
                } else {
                    builder.append(obj.toString());
                }
                builder.append("}");
            }
            builder.append("}");
        }
        return builder.toString();
    }

    public static <T> String dumpArray(T[] arr) {
        StringBuilder builder = new StringBuilder();
        if (null == arr) {
            builder.append("null");
        } else {
            Object obj = null;
            builder.append("{size: " + arr.length);
            int count = arr.length;
            for (int i = 0; i < count; ++i) {
                obj = arr[i];
                builder.append(", [" + i + "]: {");
                if (null == obj) {
                    builder.append("null");
                } else {
                    builder.append(obj.toString());
                }
                builder.append("}");
            }
            builder.append("}");
        }
        return builder.toString();
    }

    public static String dumpMeasureSpec(int measureSpec) {
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        int size = View.MeasureSpec.getSize((int)measureSpec);
        String modeName = null;
        modeName = mode == Integer.MIN_VALUE ? "AT_MOST" : (mode == 0x40000000 ? "EXACTLY" : "UNSPECIFIED");
        return String.format("{hex: 0x%08x, mode: %s, size: %d }", measureSpec, modeName, size);
    }

    public static <T> String toHexString(T value) {
        if (null == value) {
            return "null";
        }
        if (value instanceof Integer) {
            return String.format("0x%08x", value);
        }
        if (value instanceof Long) {
            return String.format("0x%08x", value);
        }
        return value.toString();
    }

    public static String dumpLayoutParams(ViewGroup.LayoutParams params) {
        if (null == params) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{width: ");
        if (-1 == params.width) {
            builder.append("match_parent");
        } else if (-2 == params.width) {
            builder.append("wrap_content");
        } else {
            builder.append(params.width);
        }
        builder.append(", height: ");
        if (-1 == params.height) {
            builder.append("match_parent");
        } else if (-2 == params.height) {
            builder.append("wrap_content");
        } else {
            builder.append(params.height);
        }
        builder.append("}");
        return builder.toString();
    }

    public static String parseImageUrl(String url) {
        if (CommonUtils.isStringInvalid(url)) {
            return "";
        }
        if (url.indexOf(PROTOCOL_HTTPS) >= 0) {
            return FileUploadTask.getBacketName() + CommonRegex.getImgBacket(url);
        }
        return url;
    }

    public static void installApk(Context context, File apkFile) {
        Intent intent = new Intent("android.intent.action.VIEW");
        apkFile.setReadable(true, false);
        if (Build.VERSION.SDK_INT >= 24) {
            Uri contentUri = FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".fileprovider"), (File)apkFile);
            intent.addFlags(1);
            intent.setDataAndType(contentUri, "application/vnd.android.package-archive");
        } else {
            intent.setDataAndType(Uri.parse((String)("file://" + apkFile.getAbsolutePath())), "application/vnd.android.package-archive");
            intent.setFlags(0x10000000);
        }
        if (context.getPackageManager().queryIntentActivities(intent, 0).size() > 0) {
            context.startActivity(intent);
        }
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int dp2px(float dp) {
        return (int)(dp * Resources.getSystem().getDisplayMetrics().density + 0.5f);
    }

    public static int sp2px(float sp) {
        return (int)(sp * Resources.getSystem().getDisplayMetrics().scaledDensity + 0.5f);
    }

    public static int px2dp(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static String replaceBlank(String src) {
        String dest = "";
        if (CommonUtils.isStringInvalid(src)) {
            return dest;
        }
        Matcher matcher = PATTERN.matcher(src);
        dest = matcher.replaceAll("");
        return dest;
    }

    public static String formatFloat(String format, Double value) {
        if (TextUtils.isEmpty((CharSequence)format)) {
            format = "0.00";
        }
        DecimalFormat df = new DecimalFormat(format);
        df.setRoundingMode(RoundingMode.HALF_EVEN);
        return df.format(value);
    }

    public static long dateToStamp(String format, String s) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.CHINA);
        Date date = simpleDateFormat.parse(s);
        return date.getTime();
    }

    public static String stampToDate(String format, long s) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.CHINA);
        Date date = new Date(s);
        String res = simpleDateFormat.format(date);
        return res;
    }
}

