/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.clientcommon;

import com.shouzhan.clientcommon.CommonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonRegex {
    private static final int REG_NAME_LENGTH = 20;
    private static final String REG_NUMBER = "[^0-9]";
    private static final String REG_COMMON_PHONE = "(^(\\d{2,4}[-_\uff0d\u2014]?)?\\d{3,8}([-_\uff0d\u2014]?\\d{3,8})?([-_\uff0d\u2014]?\\d{1,7})?$)|(^0?1\\d{10}$)";
    private static final String REG_PASSWORD = "^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,}$";
    private static final String REG_MOBILE = "^1\\d{10}$";
    private static final String REG_USER_NAME = "^[a-z0-9_]{6,20}$";
    private static final String REG_NAME = "^([\\u4E00-\\u9FA5]{1,10})$";
    private static final String REG_ID_CARD = "(^\\d{15}$)|(^\\d{17}([0-9]|X)$)";
    private static final String REG_BANK_CARD = "^(\\d{8,26})$";
    private static final String REG_COMPANY = "^[\\u4e00-\\u9fa5]{1,30}$";
    private static final String BACKET = "aliyuncs.com(.*)\\?";
    private static final String ALI_PAY_CODE = "^(((2[5-9])|(30))\\d{14,22})$";
    private static final String WX_PAY_CODE = "^1\\d{17}$";

    public static boolean isPwdInValid(String password) {
        if (CommonUtils.isStringInvalid(password)) {
            return true;
        }
        return !CommonRegex.isMatch(REG_PASSWORD, password);
    }

    public static boolean isMobileInValid(String mobile) {
        if (CommonUtils.isStringInvalid(mobile)) {
            return true;
        }
        return !CommonRegex.isMatch(REG_MOBILE, mobile);
    }

    public static boolean isPayCode(String qrCode) {
        if (CommonUtils.isStringInvalid(qrCode)) {
            return true;
        }
        return !CommonRegex.isMatch(ALI_PAY_CODE, qrCode) && !CommonRegex.isMatch(WX_PAY_CODE, qrCode);
    }

    public static boolean isWechatCode(String qrCode) {
        if (CommonUtils.isStringInvalid(qrCode)) {
            return false;
        }
        return CommonRegex.isMatch(WX_PAY_CODE, qrCode);
    }

    public static boolean isAliPayCode(String qrCode) {
        if (CommonUtils.isStringInvalid(qrCode)) {
            return false;
        }
        return CommonRegex.isMatch(ALI_PAY_CODE, qrCode);
    }

    public static boolean isUserNameInValid(String username) {
        if (CommonUtils.isStringInvalid(username)) {
            return true;
        }
        return !CommonRegex.isMatch(REG_USER_NAME, username);
    }

    public static boolean isNameInValid(String name) {
        if (CommonUtils.isStringInvalid(name)) {
            return true;
        }
        if (CommonRegex.isMatch(REG_NAME, name)) {
            return false;
        }
        return CommonRegex.getRealLength(name) >= 20;
    }

    public static boolean isRealNameInValid(String name) {
        if (CommonUtils.isStringInvalid(name)) {
            return true;
        }
        return !CommonRegex.isMatch(REG_NAME, name);
    }

    public static boolean isIDCardInValid(String idCard) {
        if (CommonUtils.isStringInvalid(idCard)) {
            return true;
        }
        return !CommonRegex.isMatch(REG_ID_CARD, idCard);
    }

    public static boolean isBankCardInValid(String bankCardId) {
        if (CommonUtils.isStringInvalid(bankCardId)) {
            return true;
        }
        return !CommonRegex.isMatch(REG_BANK_CARD, bankCardId);
    }

    public static boolean isCompanyName(String companyName) {
        if (CommonUtils.isStringInvalid(companyName)) {
            return true;
        }
        return !CommonRegex.isMatch(REG_COMPANY, companyName);
    }

    public static boolean isPhone(String phone) {
        if (CommonUtils.isStringInvalid(phone)) {
            return true;
        }
        return !CommonRegex.isMatch(REG_COMMON_PHONE, phone);
    }

    public static boolean isMatch(String pattern, String content) {
        return Pattern.matches(pattern, content);
    }

    public static int getInteger(String content) {
        Pattern p = Pattern.compile(REG_NUMBER);
        Matcher m = p.matcher(content);
        return Integer.parseInt(m.replaceAll("").trim());
    }

    public static int getRealLength(String str) {
        int m = 0;
        char[] arr = str.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char c = arr[i];
            if (c >= '\u0391' && c <= '\uffe5') {
                m += 2;
                continue;
            }
            if (c < '\u0000' || c > '\u00ff') continue;
            ++m;
        }
        return m;
    }

    public static String getMobileNumber(String mobile) {
        return mobile.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
    }

    public static String getImgBacket(String url) {
        Pattern p = Pattern.compile(BACKET);
        Matcher m = p.matcher(url);
        if (m.find()) {
            return m.group(1);
        }
        return url;
    }

    public static List<String> getSubUtil(String soap, String regex) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(soap);
        while (m.find()) {
            int i = 1;
            list.add(m.group(i));
            ++i;
        }
        return list;
    }

    public static String getSubUtilSimple(String soap, String rgex) {
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(soap);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }
}

