/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.clientcommon;

import com.shouzhan.clientcommon.AndroidDpConvertMobile;
import java.util.List;

public class AndroidDpConvertTV
extends AndroidDpConvertMobile {
    public AndroidDpConvertTV() {
        this(false);
    }

    public AndroidDpConvertTV(boolean debug) {
        super(debug, "app");
    }

    @Override
    protected String getClassTag() {
        return this.getClass().getSimpleName();
    }

    @Override
    protected boolean isConvertTextSize() {
        return false;
    }

    @Override
    protected boolean isConvertDebugString() {
        return false;
    }

    @Override
    public void fetchConverters(List<AndroidDpConvertMobile.DimenConverter> list) {
        list.add(new D1920x1080Converter());
        list.add(new D1920x1008Converter());
        list.add(new D1366x720Converter());
    }

    protected abstract class TvDpiBaseConverter
    extends AndroidDpConvertMobile.DpiBaseConverter {
        protected TvDpiBaseConverter() {
        }

        @Override
        public boolean performDimenConvert() {
            AndroidDpConvertMobile.IConverter c = new AndroidDpConvertMobile.IConverter(){

                @Override
                public double conversion(String unit, double value) {
                    return TvDpiBaseConverter.this.convertDimen(value);
                }

                @Override
                public String getUnits() {
                    return "sp|dip|dp|px";
                }
            };
            return this.performDimenConvert(this.getDefaultValuesPath(), this.getConvertValuesPath(), "dimens.xml", c);
        }

        @Override
        public boolean performTxSizeDimenConvert() {
            AndroidDpConvertMobile.IConverter c = new AndroidDpConvertMobile.IConverter(){

                @Override
                public double conversion(String unit, double value) {
                    return TvDpiBaseConverter.this.convertTxSizeDimen(value);
                }

                @Override
                public String getUnits() {
                    return "sp|dip|dp|px";
                }
            };
            return this.performDimenConvert(this.getDefaultValuesPath(), this.getConvertValuesPath(), "txsizes.xml", c);
        }
    }

    protected class D1366x720Converter
    extends TvDpiBaseConverter {
        protected D1366x720Converter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public String getConvertValuesName() {
            return "values-1366x720";
        }

        @Override
        public double convertDimen(double value) {
            return value * 2.0 / 3.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }
    }

    protected class D1920x1008Converter
    extends TvDpiBaseConverter {
        protected D1920x1008Converter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public String getConvertValuesName() {
            return "values-1920x1008";
        }

        @Override
        public double convertDimen(double value) {
            return value * 2.0 / 3.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }
    }

    protected class D1920x1080Converter
    extends TvDpiBaseConverter {
        protected D1920x1080Converter() {
        }

        @Override
        public String noteText() {
            return this.getClass().getSimpleName();
        }

        @Override
        public String getConvertValuesName() {
            return "values-1920x1080";
        }

        @Override
        public double convertDimen(double value) {
            return value / 2.0;
        }

        @Override
        public double convertTxSizeDimen(double value) {
            return this.convertDimen(value);
        }
    }
}

