/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.sovereign.ui;

import android.content.Context;
import android.util.SparseArray;
import android.view.View;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.annimon.stream.Stream;
import com.fshows.android.sovereign.ui.UiOperation;
import com.fshows.android.stark.utils.FsLogUtil;

public class SovBasePresenter
implements LifecycleObserver,
LifecycleOwner,
UiOperation {
    private static final String TAG = "Lifecycle.Presenter";
    private Lifecycle lifecycle;
    private View rootView;
    private Context context;
    private SparseArray<View> views = new SparseArray();

    public SovBasePresenter(Context context, Lifecycle lifecycle, View contentView) {
        this.context = context;
        this.rootView = contentView;
        this.lifecycle = lifecycle;
        lifecycle.addObserver((LifecycleObserver)this);
    }

    @NonNull
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    public <T> T findViewById(int resId) {
        View view = (View)this.views.get(resId);
        if (view != null) {
            return (T)view;
        }
        return (T)this.rootView.findViewById(resId);
    }

    @Override
    public boolean canUpdateUi() {
        return Stream.of((Object[])new Lifecycle.State[]{Lifecycle.State.STARTED, Lifecycle.State.RESUMED}).anyMatch(p -> p == this.lifecycle.getCurrentState());
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_CREATE)
    @CallSuper
    public void onCreate() {
        FsLogUtil.debug((String)TAG, (String)"onCreate: {}", (Object[])new Object[]{this.getClass().getCanonicalName()});
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    @CallSuper
    public void onStart() {
        FsLogUtil.debug((String)TAG, (String)"onStart: {}", (Object[])new Object[]{this.getClass().getCanonicalName()});
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    @CallSuper
    public void onResume() {
        FsLogUtil.debug((String)TAG, (String)"onResume: {}", (Object[])new Object[]{this.getClass().getCanonicalName()});
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    @CallSuper
    public void onPause() {
        FsLogUtil.debug((String)TAG, (String)"onPause: {}", (Object[])new Object[]{this.getClass().getCanonicalName()});
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    @CallSuper
    public void onStop() {
        FsLogUtil.debug((String)TAG, (String)"onStop: {}", (Object[])new Object[]{this.getClass().getCanonicalName()});
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    @CallSuper
    public void onDestroy() {
        FsLogUtil.debug((String)TAG, (String)"onDestroy: {}", (Object[])new Object[]{this.getClass().getCanonicalName()});
    }
}

