/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.sovereign.modules.hotpatch.bundle;

import com.fshows.android.sovereign.modules.hotpatch.bundle.IBundleArchive;
import com.fshows.android.sovereign.utils.SovZipUtil;
import com.fshows.android.stark.exception.FsException;
import com.fshows.android.stark.utils.FsLogUtil;
import com.fshows.android.stark.utils.MD5Util;
import com.google.common.base.Strings;
import java.io.File;

public class AbsBundleArchive
implements IBundleArchive {
    private static final String TAG = "SOVEREIGN.BundleArchive";
    private File bundleArchiveFile;

    protected AbsBundleArchive(File bundleArchiveFile) {
        this.bundleArchiveFile = bundleArchiveFile;
        FsLogUtil.debug((String)TAG, (String)"bundle archive: {}", (Object[])new Object[]{bundleArchiveFile.toString()});
    }

    @Override
    public String getChecksum() {
        String checksum = null;
        if (this.bundleArchiveFile != null) {
            checksum = MD5Util.getFileMD5((File)this.bundleArchiveFile);
        }
        return Strings.nullToEmpty(checksum);
    }

    public boolean exists() {
        return this.bundleArchiveFile.exists();
    }

    @Override
    public void unarchive(File dest) throws FsException {
        if (this.bundleArchiveFile == null || !this.bundleArchiveFile.exists()) {
            throw new FsException("bundle\u538b\u7f29\u5305\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (!this.bundleArchiveFile.isFile() && !this.bundleArchiveFile.exists()) {
            throw new FsException("bundle\u4e0d\u5b58\u5728");
        }
        try {
            if (!"zip".equalsIgnoreCase(this.getArchiveType())) {
                throw new FsException("\u4e0d\u652f\u6301\u7684\u538b\u7f29\u7c7b\u578b {}", new Object[]{"zip"});
            }
            SovZipUtil.unzip(this.getArchiveFile(), dest.getAbsolutePath());
        }
        catch (Exception e) {
            FsLogUtil.error((String)"unarchive bundle failed, {}", (String)e.toString(), (Object[])new Object[0]);
            throw new FsException(e);
        }
    }

    @Override
    public File getArchiveFile() {
        return this.bundleArchiveFile;
    }

    @Override
    public File getArchiveLocation() {
        return this.bundleArchiveFile != null ? this.bundleArchiveFile.getParentFile() : null;
    }

    @Override
    public String getArchiveFileName() {
        return this.bundleArchiveFile != null ? this.bundleArchiveFile.getName() : null;
    }
}

