/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.sovereign;

import android.app.Application;
import android.content.Context;
import androidx.annotation.Keep;
import com.annimon.stream.function.Consumer;
import com.annimon.stream.function.Supplier;
import com.fshows.android.foundation.gears.FsGears;
import com.fshows.android.sovereign.scheme.SovereignDebugSchemeAction;
import com.fshows.android.sovereign.utils.SovSharedPreferenceUtil;
import com.fshows.android.sovereign.utils.SovUtil;
import com.fshows.android.stark.FsFoundationInitializer;
import com.fshows.android.stark.scheme.ISchemeAction;
import com.fshows.android.stark.scheme.SchemeDispatcher;
import com.fshows.android.stark.utils.FsLogUtil;
import com.fshows.android.stark.utils.KeychainUtil;
import com.google.common.base.Strings;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.cache.CacheMode;
import com.lzy.okgo.interceptor.HttpLoggingInterceptor;
import com.lzy.okgo.model.HttpHeaders;
import io.sentry.Sentry;
import io.sentry.SentryClientFactory;
import io.sentry.android.AndroidSentryClientFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

@Keep
public class SovInitializer {
    private static final String TAG = "SOVEREIGN.SovInitializer";
    private static Application application;

    public static void init(Context context) {
        try {
            application = (Application)context.getApplicationContext();
            SovInitializer.initSentry((Application)context.getApplicationContext());
            SovInitializer.initNetworkConfig(application);
            SovInitializer.registerSchemeAction();
        }
        catch (Exception ex) {
            FsLogUtil.error((String)TAG, (String)"SovInitializer: {}", (Object[])new Object[]{ex.toString()});
        }
    }

    private static void registerSchemeAction() {
        SchemeDispatcher.getInstance().registerAction((ISchemeAction)new SovereignDebugSchemeAction());
    }

    public static Context getApplicationContext() {
        return application;
    }

    private static void initNetworkConfig(Application application) {
        FsLogUtil.info((String)TAG, (String)"init NetworkConfig", (Object[])new Object[0]);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(5L, TimeUnit.SECONDS);
        builder.readTimeout(60000L, TimeUnit.MILLISECONDS);
        builder.writeTimeout(60000L, TimeUnit.MILLISECONDS);
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor("Sovereign_HttpClient");
        loggingInterceptor.setPrintLevel(FsFoundationInitializer.isDebug() ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.HEADERS);
        loggingInterceptor.setColorLevel(FsFoundationInitializer.isDebug() ? Level.ALL : Level.INFO);
        builder.addInterceptor((Interceptor)loggingInterceptor);
        HttpHeaders.setUserAgent((String)SovUtil.getUserAgent());
        OkGo.getInstance().init(application).setOkHttpClient(builder.build()).setCacheMode(CacheMode.NO_CACHE).addCommonHeaders(new HttpHeaders("Accept-Encoding", "gzip,deflate")).setRetryCount(0);
    }

    private static void initSentry(Application application) {
        try {
            FsGears.init((Context)application);
            String sentryDsn = KeychainUtil.getKeychainItemValue((String)"sentry.dsn", (String)"");
            if (!Strings.isNullOrEmpty((String)sentryDsn)) {
                Sentry.init((String)sentryDsn, (SentryClientFactory)new AndroidSentryClientFactory((Context)application));
            }
        }
        catch (Throwable e) {
            FsLogUtil.error((String)TAG, (String)"initSentry failed.. {}", (Object[])new Object[]{e.toString()});
        }
    }

    public static void enablePatch(Context context, boolean enable) {
        if (!FsFoundationInitializer.isDebug()) {
            return;
        }
        Consumer.Util.safe(p -> SovSharedPreferenceUtil.putBoolean((Context)application, "SOVEREIGN.debug-patch-enable", enable)).accept(null);
    }

    public static boolean isPatchEnabled(Context context) {
        if (!FsFoundationInitializer.isDebug()) {
            return true;
        }
        return (Boolean)Supplier.Util.safe(() -> SovSharedPreferenceUtil.getBoolean(context, "SOVEREIGN.debug-patch-enable", true), (Object)true).get();
    }
}

