/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.sovereign.utils;

import android.content.Context;
import android.os.Build;
import com.annimon.stream.function.Supplier;
import com.fshows.android.sovereign.SovInitializer;
import com.fshows.android.stark.utils.AppHelper;
import com.fshows.android.stark.utils.VersionUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.net.URLEncoder;

public class SovUtil {
    public static String getAppCodeName() {
        return AppHelper.getMetaData((String)"SOV_CODE_NAME");
    }

    public static String getAppMajorMinorVersion() {
        return (String)Supplier.Util.safe(() -> {
            Context context = SovInitializer.getApplicationContext();
            String packageName = context.getPackageName();
            String versionName = context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionName;
            return VersionUtil.getVersion((String)versionName, (int)2);
        }).get();
    }

    public static String getUserAgent() {
        return (String)Supplier.Util.safe(() -> {
            StringBuilder sb = new StringBuilder();
            Context context = SovInitializer.getApplicationContext();
            String client = Strings.lenientFormat((String)"FShows-Sovereign %s/%s", (Object[])new Object[]{context.getPackageName(), SovUtil.getAppMajorMinorVersion()});
            String brand = URLEncoder.encode(Build.BRAND, "utf-8");
            String osVersion = Strings.lenientFormat((String)"Android %s_%s", (Object[])new Object[]{Build.VERSION.RELEASE, Build.VERSION.SDK_INT});
            Joiner.on((String)" ").appendTo(sb, (Object)client, (Object)osVersion, new Object[]{brand});
            return sb.toString();
        }, (Object)"").get();
    }
}

