/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.sovereign;

import android.app.Application;
import android.content.Context;
import android.support.annotation.Keep;
import com.fshows.android.sovereign.utils.SovUtil;
import com.fshows.android.stark.FsFoundationInitializer;
import com.fshows.android.stark.utils.FsLogUtil;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.cache.CacheMode;
import com.lzy.okgo.interceptor.HttpLoggingInterceptor;
import com.lzy.okgo.model.HttpHeaders;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

@Keep
public class SovInitializer {
    private static final String TAG = "SovInitializer";
    private static Application application;

    public static void init(Context context) {
        try {
            application = (Application)context.getApplicationContext();
            SovInitializer.initNetworkConfig(application);
        }
        catch (Exception ex) {
            FsLogUtil.error((String)TAG, (String)"SovInitializer: {}", (Object[])new Object[]{ex.toString()});
        }
    }

    public static Context getApplicationContext() {
        return application;
    }

    private static void initNetworkConfig(Application application) {
        FsLogUtil.info((String)TAG, (String)"init NetworkConfig", (Object[])new Object[0]);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(5L, TimeUnit.SECONDS);
        builder.readTimeout(60000L, TimeUnit.MILLISECONDS);
        builder.writeTimeout(60000L, TimeUnit.MILLISECONDS);
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor("Sovereign_HttpClient");
        loggingInterceptor.setPrintLevel(HttpLoggingInterceptor.Level.BODY);
        loggingInterceptor.setColorLevel(FsFoundationInitializer.isDebug() ? Level.ALL : Level.INFO);
        builder.addInterceptor((Interceptor)loggingInterceptor);
        HttpHeaders.setUserAgent((String)SovUtil.getUserAgent());
        OkGo.getInstance().init(application).setOkHttpClient(builder.build()).setCacheMode(CacheMode.NO_CACHE).addCommonHeaders(new HttpHeaders("Accept-Encoding", "gzip,deflate")).setRetryCount(0);
    }
}

