/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.rogers.mix;

import android.app.IntentService;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Intent;
import android.os.Build;
import com.fshows.android.rogers.mix.MixPushMessage;

public abstract class MixPushIntentService
extends IntentService {
    public MixPushIntentService() {
        super("MixPushIntentService");
    }

    public final void onHandleIntent(Intent intent) {
        this.createStartForeground();
        if (intent != null) {
            String action = intent.getAction();
            try {
                MixPushMessage message = (MixPushMessage)intent.getSerializableExtra("message");
                if ("com.mixpush.RECEIVE_THROUGH_MESSAGE".equals(action)) {
                    this.onReceivePassThroughMessage(message);
                } else if ("com.mixpush.NOTIFICATION_ARRIVED".equals(action)) {
                    this.onNotificationMessageArrived(message);
                } else if ("com.mixpush.NOTIFICATION_CLICKED".equals(action)) {
                    this.onNotificationMessageClicked(message);
                } else if ("com.mixpush.CLIENT_ID".equals(action)) {
                    this.onReceiveClientId(message);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createStartForeground() {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
            NotificationChannel channel = new NotificationChannel("PushIntentService_001", (CharSequence)"\u63a8\u9001\u901a\u77e5", 4);
            notificationManager.createNotificationChannel(channel);
            Notification notification = new Notification.Builder(this.getApplicationContext(), "PushIntentService_001").build();
            this.startForeground(1, notification);
        } else {
            this.startForeground(1, new Notification());
        }
    }

    public abstract void onReceivePassThroughMessage(MixPushMessage var1);

    public abstract void onNotificationMessageClicked(MixPushMessage var1);

    public void onNotificationMessageArrived(MixPushMessage message) {
    }

    public abstract void onReceiveClientId(MixPushMessage var1);
}

