/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.aidl;

import android.os.Parcel;
import android.os.Parcelable;
import anet.channel.request.BodyEntry;
import anet.channel.util.ALog;
import anetwork.channel.Header;
import anetwork.channel.Param;
import anetwork.channel.Request;
import anetwork.channel.aidl.e;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParcelableRequest
implements Parcelable {
    public Request request;
    public BodyEntry bodyEntry;
    public int retryTime;
    public String url;
    public String charset;
    public boolean allowRedirect;
    public String method;
    public Map<String, String> headers = null;
    public Map<String, String> params = null;
    public int connectTimeout;
    public int readTimeout;
    public String bizId;
    public String seqNo;
    public Map<String, String> extProperties;
    public static final Parcelable.Creator<ParcelableRequest> CREATOR = new e();

    public ParcelableRequest(Request request) {
        this.request = request;
        if (request != null) {
            List<Param> list;
            this.url = request.getUrlString();
            this.retryTime = request.getRetryTime();
            this.charset = request.getCharset();
            this.allowRedirect = request.getFollowRedirects();
            this.method = request.getMethod();
            List<Header> list2 = request.getHeaders();
            if (list2 != null) {
                this.headers = new HashMap<String, String>();
                for (Object object : list2) {
                    this.headers.put(object.getName(), object.getValue());
                }
            }
            if ((list = request.getParams()) != null) {
                this.params = new HashMap<String, String>();
                for (Param param : list) {
                    this.params.put(param.getKey(), param.getValue());
                }
            }
            this.bodyEntry = request.getBodyEntry();
            this.connectTimeout = request.getConnectTimeout();
            this.readTimeout = request.getReadTimeout();
            this.bizId = request.getBizId();
            this.seqNo = request.getSeqNo();
            this.extProperties = request.getExtProperties();
        }
    }

    public ParcelableRequest() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        if (this.request == null) {
            return;
        }
        try {
            parcel.writeInt(this.request.getRetryTime());
            parcel.writeString(this.url);
            parcel.writeString(this.request.getCharset());
            parcel.writeInt(this.request.getFollowRedirects() ? 1 : 0);
            parcel.writeString(this.request.getMethod());
            parcel.writeInt(this.headers == null ? 0 : 1);
            if (this.headers != null) {
                parcel.writeMap(this.headers);
            }
            parcel.writeInt(this.params == null ? 0 : 1);
            if (this.params != null) {
                parcel.writeMap(this.params);
            }
            parcel.writeParcelable((Parcelable)this.bodyEntry, 0);
            parcel.writeInt(this.request.getConnectTimeout());
            parcel.writeInt(this.request.getReadTimeout());
            parcel.writeString(this.request.getBizId());
            parcel.writeString(this.request.getSeqNo());
            Map<String, String> map = this.request.getExtProperties();
            parcel.writeInt(map == null ? 0 : 1);
            if (map != null) {
                parcel.writeMap(map);
            }
            return;
        }
        catch (Throwable throwable) {
            ALog.w("anet.ParcelableRequest", "[writeToParcel]", null, throwable, new Object[0]);
            return;
        }
    }

    public static ParcelableRequest readFromParcel(Parcel parcel) {
        ParcelableRequest parcelableRequest = new ParcelableRequest();
        try {
            parcelableRequest.retryTime = parcel.readInt();
            parcelableRequest.url = parcel.readString();
            parcelableRequest.charset = parcel.readString();
            parcelableRequest.allowRedirect = parcel.readInt() == 1;
            parcelableRequest.method = parcel.readString();
            if (parcel.readInt() != 0) {
                parcelableRequest.headers = parcel.readHashMap(ParcelableRequest.class.getClassLoader());
            }
            if (parcel.readInt() != 0) {
                parcelableRequest.params = parcel.readHashMap(ParcelableRequest.class.getClassLoader());
            }
            parcelableRequest.bodyEntry = (BodyEntry)parcel.readParcelable(ParcelableRequest.class.getClassLoader());
            parcelableRequest.connectTimeout = parcel.readInt();
            parcelableRequest.readTimeout = parcel.readInt();
            parcelableRequest.bizId = parcel.readString();
            parcelableRequest.seqNo = parcel.readString();
            if (parcel.readInt() != 0) {
                parcelableRequest.extProperties = parcel.readHashMap(ParcelableRequest.class.getClassLoader());
            }
        }
        catch (Throwable throwable) {
            ALog.w("anet.ParcelableRequest", "[readFromParcel]", null, throwable, new Object[0]);
        }
        return parcelableRequest;
    }

    public String getExtProperty(String string) {
        if (this.extProperties == null) {
            return null;
        }
        return this.extProperties.get(string);
    }
}

