/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.strategy;

import android.text.TextUtils;
import anet.channel.strategy.l;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ConnProtocol
implements Serializable {
    private static final long serialVersionUID = -3523201990674557001L;
    private static Map<String, ConnProtocol> protocolMap = new HashMap<String, ConnProtocol>();
    public static final ConnProtocol HTTP = ConnProtocol.valueOf("http", null, null);
    public static final ConnProtocol HTTPS = ConnProtocol.valueOf("https", null, null);
    public final String protocol;
    public final String rtt;
    public final String publicKey;
    public final String name;
    final int isHttp;

    public static ConnProtocol valueOf(l.a a2) {
        if (a2 == null) {
            return null;
        }
        return ConnProtocol.valueOf(a2.b, a2.g, a2.h);
    }

    @Deprecated
    public static ConnProtocol valueOf(String string, String string2, String string3, @Deprecated boolean bl) {
        return ConnProtocol.valueOf(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnProtocol valueOf(String object, String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return null;
        }
        String string3 = ConnProtocol.buildName((String)object, string, string2);
        Map<String, ConnProtocol> map = protocolMap;
        synchronized (map) {
            if (protocolMap.containsKey(string3)) {
                return protocolMap.get(string3);
            }
            object = new ConnProtocol(string3, (String)object, string, string2);
            protocolMap.put(string3, (ConnProtocol)object);
            return object;
        }
    }

    private ConnProtocol(String string, String string2, String string3, String string4) {
        this.name = string;
        this.protocol = string2;
        this.rtt = string3;
        this.publicKey = string4;
        this.isHttp = "http".equalsIgnoreCase(string2) || "https".equalsIgnoreCase(string2) ? 1 : 0;
    }

    private static String buildName(String string, String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(18);
        stringBuilder.append(string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append("_").append(string2);
        } else {
            stringBuilder.append("_0rtt");
        }
        stringBuilder.append("_");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ConnProtocol)) {
            return false;
        }
        return this.name.equals(((ConnProtocol)object).name);
    }

    public int hashCode() {
        int n2 = 527 + this.protocol.hashCode();
        if (this.rtt != null) {
            n2 = 31 * n2 + this.rtt.hashCode();
        }
        if (this.publicKey != null) {
            n2 = 31 * n2 + this.publicKey.hashCode();
        }
        return n2;
    }
}

