/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.beacon;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.alibaba.sdk.android.beacon.a;
import com.alibaba.sdk.android.beacon.b;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Beacon {
    private final String mAppKey;
    private final String mAppSecret;
    private final Map<String, String> mExtras;
    private final HandlerThread a;
    private final b a;
    private final List<OnUpdateListener> a;
    private final List<OnServiceErrListener> b;
    private Handler mHandler;
    private long mLoopInterval;
    private int a = 255;

    private Beacon(Builder builder) {
        this.b = new ArrayList<OnServiceErrListener>();
        this.mAppKey = builder.mAppKey;
        this.mAppSecret = builder.mAppSecret;
        this.mExtras = builder.mExtras;
        this.mLoopInterval = builder.mLoopInterval;
        this.a = new b(this);
        this.a = new HandlerThread("Beacon Daemon");
        this.a.start();
        this.a();
    }

    private void a() {
        this.mHandler = new BeaconHandler(this.a.getLooper());
    }

    public List<Config> getConfigs() {
        return this.a.a();
    }

    public void addUpdateListener(OnUpdateListener onUpdateListener) {
        Message message = Message.obtain();
        message.what = 4;
        message.obj = onUpdateListener;
        this.mHandler.sendMessage(message);
    }

    public void addServiceErrListener(OnServiceErrListener onServiceErrListener) {
        Message message = Message.obtain();
        message.what = 6;
        message.obj = onServiceErrListener;
        this.mHandler.sendMessage(message);
    }

    public void start(Context context) {
        if (!this.isStarted()) {
            Message message = Message.obtain();
            message.what = 0;
            message.obj = context;
            this.mHandler.sendMessage(message);
        }
    }

    public void stop() {
        if (this.isStarted()) {
            Message message = Message.obtain();
            message.what = 3;
            this.mHandler.sendMessage(message);
        }
    }

    void a(Error error) {
        Message message = Message.obtain();
        message.what = 7;
        message.obj = error;
        this.mHandler.sendMessage(message);
    }

    private void a(Context context) {
        Message message = Message.obtain();
        message.what = 1;
        message.obj = context;
        this.mHandler.sendMessage(message);
    }

    private void b(Context context) {
        Message message = Message.obtain();
        message.what = 2;
        message.obj = context;
        this.mHandler.sendMessage(message);
    }

    private void c(Context context) {
        this.b(context);
        this.a = 1;
    }

    private void d(Context context) {
        this.a.a(context, this.mAppKey, this.mAppSecret, this.mExtras);
        List<Config> list = this.a.a();
        for (OnUpdateListener onUpdateListener : this.a) {
            onUpdateListener.onUpdate(list);
        }
    }

    private void e(Context context) {
        if (this.mHandler.hasMessages(2)) {
            this.mHandler.removeMessages(2);
        }
        this.a(context);
        this.mHandler.sendEmptyMessageDelayed(2, this.mLoopInterval);
    }

    private void b() {
        if (Build.VERSION.SDK_INT >= 18) {
            this.mHandler.getLooper().quitSafely();
        } else {
            this.mHandler.getLooper().quit();
        }
        this.a();
    }

    private void a(OnUpdateListener onUpdateListener) {
        this.a.add(onUpdateListener);
    }

    private void b(OnUpdateListener onUpdateListener) {
        this.a.remove(onUpdateListener);
    }

    private void a(OnServiceErrListener onServiceErrListener) {
        this.b.add(onServiceErrListener);
    }

    private void b(Error error) {
        for (OnServiceErrListener onServiceErrListener : this.b) {
            onServiceErrListener.onErr(error);
        }
    }

    private boolean isStarted() {
        return this.a == 1;
    }

    public static final void setPrepare(boolean bl) {
        com.alibaba.sdk.android.beacon.a.a = bl;
    }

    public static final class Config {
        public final String key;
        public final String value;

        public Config(String string, String string2) {
            this.key = string;
            this.value = string2;
        }
    }

    public static final class Error {
        public final String errCode;
        public final String errMsg;

        Error(String string, String string2) {
            this.errCode = string;
            this.errMsg = string2;
        }
    }

    public static interface OnServiceErrListener {
        public void onErr(Error var1);
    }

    public static interface OnUpdateListener {
        public void onUpdate(List<Config> var1);
    }

    public static final class Builder {
        String mAppKey;
        String mAppSecret;
        Map<String, String> mExtras = new HashMap<String, String>();
        long mLoopInterval = 300000L;

        public Builder appKey(String string) {
            this.mAppKey = string.trim();
            return this;
        }

        public Builder appSecret(String string) {
            this.mAppSecret = string.trim();
            return this;
        }

        public Builder extras(Map<String, String> map) {
            this.mExtras.putAll(map);
            return this;
        }

        public Builder loopInterval(long l) {
            this.mLoopInterval = l < 60000L ? 60000L : l;
            return this;
        }

        public Beacon build() {
            return new Beacon(this);
        }
    }

    private final class BeaconHandler
    extends Handler {
        static final int MSG_START = 0;
        static final int MSG_UPDATE = 1;
        static final int MSG_START_POLLING = 2;
        static final int MSG_STOP_POLLING = 3;
        static final int MSG_ADD_UPDATE_LISTENER = 4;
        static final int MSG_REMOVE_UPDATE_LISTENER = 5;
        static final int MSG_ADD_ERR_LISTENER = 6;
        static final int MSG_ERR_CALLBACK = 7;

        BeaconHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            try {
                switch (message.what) {
                    case 0: {
                        Context context = (Context)message.obj;
                        Beacon.this.c(context);
                        break;
                    }
                    case 1: {
                        Context context = (Context)message.obj;
                        Beacon.this.d(context);
                        break;
                    }
                    case 2: {
                        Context context = (Context)message.obj;
                        Beacon.this.e(context);
                        break;
                    }
                    case 3: {
                        Beacon.this.b();
                        break;
                    }
                    case 4: {
                        OnUpdateListener onUpdateListener = (OnUpdateListener)message.obj;
                        Beacon.this.a(onUpdateListener);
                        break;
                    }
                    case 5: {
                        OnUpdateListener onUpdateListener = (OnUpdateListener)message.obj;
                        Beacon.this.b(onUpdateListener);
                        break;
                    }
                    case 6: {
                        OnServiceErrListener onServiceErrListener = (OnServiceErrListener)message.obj;
                        Beacon.this.a(onServiceErrListener);
                        break;
                    }
                    case 7: {
                        Error error = (Error)message.obj;
                        Beacon.this.b(error);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                Log.i((String)"beacon", (String)exception.getMessage(), (Throwable)exception);
            }
        }
    }
}

