/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.push.common.util;

import com.alibaba.sdk.android.ams.common.logger.AmsLogger;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolFactory {
    private static volatile ScheduledThreadPoolExecutor scheduleThreadPoolExecutor;
    private static final AtomicInteger integer;
    private static final String TAG = "MPS:ThreadPoolFactory";
    private static AmsLogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScheduledThreadPoolExecutor getScheduledExecutor() {
        if (scheduleThreadPoolExecutor != null) return scheduleThreadPoolExecutor;
        Class<ThreadPoolFactory> clazz = ThreadPoolFactory.class;
        synchronized (ThreadPoolFactory.class) {
            if (scheduleThreadPoolExecutor != null) return scheduleThreadPoolExecutor;
            scheduleThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, new ScheduledThreadFactory(TAG));
            scheduleThreadPoolExecutor.setKeepAliveTime(60L, TimeUnit.SECONDS);
            scheduleThreadPoolExecutor.allowCoreThreadTimeOut(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return scheduleThreadPoolExecutor;
        }
    }

    public static ScheduledFuture<?> schedule(Runnable runnable, long l2, TimeUnit timeUnit) {
        ScheduledFuture<?> scheduledFuture = null;
        try {
            scheduledFuture = ThreadPoolFactory.getScheduledExecutor().schedule(runnable, l2, timeUnit);
        }
        catch (Throwable throwable) {
            logger.e("ThreadPoolExecutorFactory schedule", throwable);
        }
        return scheduledFuture;
    }

    public static void execute(Runnable runnable) {
        try {
            ThreadPoolFactory.getScheduledExecutor().execute(runnable);
            return;
        }
        catch (Throwable throwable) {
            logger.e("ThreadPoolExecutorFactory execute", throwable);
            return;
        }
    }

    static {
        integer = new AtomicInteger();
        logger = AmsLogger.getLogger(TAG);
    }

    static class ScheduledThreadFactory
    implements ThreadFactory {
        private String mThreadTag;

        public ScheduledThreadFactory(String string) {
            this.mThreadTag = string;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            int n2 = integer.getAndIncrement();
            runnable = new Thread(runnable, this.mThreadTag + n2);
            ((Thread)runnable).setPriority(5);
            return runnable;
        }
    }
}

