/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.entity;

import android.text.TextUtils;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.entity.ENV;
import anet.channel.entity.c;
import anet.channel.strategy.ConnProtocol;
import java.util.HashMap;
import java.util.Map;

public class ConnType {
    public static final String SPDY = "spdy";
    public static final String HTTP2 = "http2";
    public static final String H2S = "h2s";
    public static final String QUIC = "quic";
    public static final String QUIC_PLAIN = "quicplain";
    public static final String RTT_0 = "0rtt";
    public static final String RTT_1 = "1rtt";
    public static final String PK_ACS = "acs";
    public static final String PK_CDN = "cdn";
    public static final String PK_OPEN = "open";
    public static final String PK_AUTO = "auto";
    public static ConnType HTTP = new ConnType("http");
    public static ConnType HTTPS = new ConnType("https");
    private static Map<ConnProtocol, ConnType> connTypeMap = new HashMap<ConnProtocol, ConnType>();
    private int spdyProtocol;
    private String publicKey;
    private String name = "";

    private ConnType(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnType valueOf(ConnProtocol connProtocol) {
        if (connProtocol == null) {
            return null;
        }
        if ("http".equalsIgnoreCase(connProtocol.protocol)) {
            return HTTP;
        }
        if ("https".equalsIgnoreCase(connProtocol.protocol)) {
            return HTTPS;
        }
        Map<ConnProtocol, ConnType> map = connTypeMap;
        synchronized (map) {
            if (connTypeMap.containsKey(connProtocol)) {
                return connTypeMap.get(connProtocol);
            }
            ConnType connType = new ConnType(connProtocol.toString());
            new ConnType(connProtocol.toString()).publicKey = connProtocol.publicKey;
            if (HTTP2.equalsIgnoreCase(connProtocol.protocol)) {
                connType.spdyProtocol |= 8;
            } else if (SPDY.equalsIgnoreCase(connProtocol.protocol)) {
                connType.spdyProtocol |= 2;
            } else if (H2S.equals(connProtocol.protocol)) {
                connType.spdyProtocol = 40;
            } else if (QUIC.equalsIgnoreCase(connProtocol.protocol)) {
                connType.spdyProtocol = 12;
            } else if (QUIC_PLAIN.equalsIgnoreCase(connProtocol.protocol)) {
                connType.spdyProtocol = 32780;
            }
            if (connType.spdyProtocol == 0) {
                return null;
            }
            if (!TextUtils.isEmpty((CharSequence)connProtocol.publicKey)) {
                connType.spdyProtocol |= 0x80;
                if (RTT_1.equalsIgnoreCase(connProtocol.rtt)) {
                    connType.spdyProtocol |= 0x2000;
                } else if (RTT_0.equalsIgnoreCase(connProtocol.rtt)) {
                    connType.spdyProtocol |= 0x1000;
                } else {
                    return null;
                }
            }
            connTypeMap.put(connProtocol, connType);
            return connType;
        }
    }

    public int getTnetConType() {
        return this.spdyProtocol;
    }

    public int getTnetPublicKey(boolean bl) {
        int n2;
        block6: {
            int n3;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            n2 = -1;
                            if (!PK_CDN.equals(this.publicKey)) break block2;
                            n3 = 1;
                            break block3;
                        }
                        if (GlobalAppRuntimeInfo.getEnv() != ENV.TEST) break block4;
                        n3 = 0;
                        break block3;
                    }
                    if (!PK_OPEN.equals(this.publicKey)) break block5;
                    n2 = bl ? 11 : 10;
                    break block6;
                }
                if (!PK_ACS.equals(this.publicKey)) break block6;
                n3 = bl ? 4 : 3;
            }
            n2 = n3;
        }
        return n2;
    }

    public boolean isPublicKeyAuto() {
        return PK_AUTO.equals(this.publicKey);
    }

    public boolean isH2S() {
        return this.spdyProtocol == 40;
    }

    public boolean isQuic() {
        return (this.spdyProtocol & 4) != 0;
    }

    public boolean isHttpType() {
        return this.equals(HTTP) || this.equals(HTTPS);
    }

    public boolean isSSL() {
        return (this.spdyProtocol & 0x80) != 0 || (this.spdyProtocol & 0x20) != 0 || this.spdyProtocol == 12 || this.equals(HTTPS);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ConnType)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.name.equals(((ConnType)object).name);
    }

    @Deprecated
    public TypeLevel getTypeLevel() {
        if (this.isHttpType()) {
            return TypeLevel.HTTP;
        }
        return TypeLevel.SPDY;
    }

    public int getType() {
        if (this.equals(HTTP) || this.equals(HTTPS)) {
            return c.b;
        }
        return c.a;
    }

    private int getPriority() {
        if ((this.spdyProtocol & 8) != 0) {
            return 0;
        }
        if ((this.spdyProtocol & 2) != 0) {
            return 1;
        }
        return 2;
    }

    public static int compare(ConnType connType, ConnType connType2) {
        return connType.getPriority() - connType2.getPriority();
    }

    @Deprecated
    public static enum TypeLevel {
        SPDY,
        HTTP;

    }
}

