/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.taobao.accs.AccsException;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.k;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AccsClientConfig {
    private static final String TAG = "AccsClientConfig";
    public static final int SECURITY_TAOBAO = 0;
    public static final int SECURITY_OPEN = 1;
    public static final int SECURITY_OFF = 2;
    public static final String DEFAULT_CONFIGTAG = "default";
    public static final String[] DEFAULT_CENTER_HOSTS = new String[]{"msgacs.m.taobao.com", "msgacs.wapa.taobao.com", "msgacs.waptest.taobao.com"};
    private static final String[] DEFAULT_CHANNEL_HOSTS = new String[]{"accscdn.m.taobao.com", "acs.wapa.taobao.com", "acs.waptest.taobao.com"};
    private static Context mContext;
    public static boolean loadedStaticConfig;
    @ENV
    public static int mEnv;
    private static Map<String, AccsClientConfig> mReleaseConfigs;
    private static Map<String, AccsClientConfig> mPreviewConfigs;
    private static Map<String, AccsClientConfig> mDebugConfigs;
    private String mAppKey;
    private String mAppSecret;
    private String mInappHost;
    private String mChannelHost;
    private String mStoreId;
    private int mSecurity;
    private String mAuthCode;
    private int mInappPubKey;
    private int mChannelPubKey;
    private boolean mKeepalive;
    private boolean mAutoUnit;
    private String mTag;
    private int mConfigEnv;
    private boolean mDisableChannel;
    private boolean mQuickReconnect;
    private boolean mAccsHeartbeatEnable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context getContext() {
        if (mContext != null) {
            return mContext;
        }
        Class<AccsClientConfig> clazz = AccsClientConfig.class;
        synchronized (AccsClientConfig.class) {
            if (mContext != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return mContext;
            }
            try {
                Object object = Class.forName("android.app.ActivityThread");
                object = ((Class)object).getMethod("currentActivityThread", new Class[0]).invoke(object, new Object[0]);
                mContext = (Context)object.getClass().getMethod("getApplication", new Class[0]).invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return mContext;
        }
    }

    protected AccsClientConfig() {
    }

    @Deprecated
    public static AccsClientConfig getConfig(String string) {
        Object object;
        switch (mEnv) {
            case 1: {
                object = mPreviewConfigs;
                break;
            }
            case 2: {
                object = mDebugConfigs;
                break;
            }
            default: {
                object = mReleaseConfigs;
            }
        }
        for (AccsClientConfig accsClientConfig : object.values()) {
            if (!accsClientConfig.mAppKey.equals(string) || accsClientConfig.mConfigEnv != mEnv) continue;
            return accsClientConfig;
        }
        ALog.e(TAG, "getConfigByTag return null", "appkey", string);
        return null;
    }

    public static AccsClientConfig getConfigByTag(String string) {
        Object object;
        switch (mEnv) {
            case 1: {
                object = mPreviewConfigs;
                break;
            }
            case 2: {
                object = mDebugConfigs;
                break;
            }
            default: {
                object = mReleaseConfigs;
            }
        }
        object = object.get(string);
        if (object == null) {
            ALog.e(TAG, "getConfigByTag return null", "configTag", string);
        }
        return object;
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public String getAppSecret() {
        return this.mAppSecret;
    }

    public String getInappHost() {
        return this.mInappHost;
    }

    public String getChannelHost() {
        return this.mChannelHost;
    }

    public int getSecurity() {
        return this.mSecurity;
    }

    public String getAuthCode() {
        return this.mAuthCode;
    }

    public int getInappPubKey() {
        return this.mInappPubKey;
    }

    public int getChannelPubKey() {
        return this.mChannelPubKey;
    }

    public boolean isKeepalive() {
        return this.mKeepalive;
    }

    public boolean isAutoUnit() {
        return this.mAutoUnit;
    }

    public String getTag() {
        return this.mTag;
    }

    public int getConfigEnv() {
        return this.mConfigEnv;
    }

    public boolean getDisableChannel() {
        return this.mDisableChannel;
    }

    public boolean isQuickReconnect() {
        return this.mQuickReconnect;
    }

    public String getStoreId() {
        return this.mStoreId;
    }

    public boolean isAccsHeartbeatEnable() {
        return this.mAccsHeartbeatEnable;
    }

    public String toString() {
        return "AccsClientConfig{Tag=" + this.mTag + ", ConfigEnv=" + this.mConfigEnv + ", AppKey=" + this.mAppKey + ", AppSecret=" + this.mAppSecret + ", InappHost=" + this.mInappHost + ", ChannelHost=" + this.mChannelHost + ", Security=" + this.mSecurity + ", AuthCode=" + this.mAuthCode + ", InappPubKey=" + this.mInappPubKey + ", ChannelPubKey=" + this.mChannelPubKey + ", Keepalive=" + this.mKeepalive + ", AutoUnit=" + this.mAutoUnit + ", DisableChannel=" + this.mDisableChannel + ", QuickReconnect=" + this.mQuickReconnect + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (AccsClientConfig)object;
        if (!this.mInappHost.equals(((AccsClientConfig)object).mInappHost)) {
            return false;
        }
        if (this.mInappPubKey != ((AccsClientConfig)object).mInappPubKey) {
            return false;
        }
        if (!this.mChannelHost.equals(((AccsClientConfig)object).mChannelHost)) {
            return false;
        }
        if (this.mChannelPubKey != ((AccsClientConfig)object).mChannelPubKey) {
            return false;
        }
        if (this.mSecurity != ((AccsClientConfig)object).mSecurity) {
            return false;
        }
        if (this.mConfigEnv != ((AccsClientConfig)object).mConfigEnv) {
            return false;
        }
        if (!this.mAppKey.equals(((AccsClientConfig)object).mAppKey)) {
            return false;
        }
        if (this.mKeepalive != ((AccsClientConfig)object).mKeepalive) {
            return false;
        }
        if (this.mDisableChannel != ((AccsClientConfig)object).mDisableChannel) {
            return false;
        }
        if (this.mAuthCode != null ? !this.mAuthCode.equals(((AccsClientConfig)object).mAuthCode) : ((AccsClientConfig)object).mAuthCode != null) {
            return false;
        }
        if (this.mAppSecret != null ? !this.mAppSecret.equals(((AccsClientConfig)object).mAppSecret) : ((AccsClientConfig)object).mAppSecret != null) {
            return false;
        }
        return this.mTag.equals(((AccsClientConfig)object).mTag);
    }

    static {
        loadedStaticConfig = false;
        mEnv = 0;
        mReleaseConfigs = new ConcurrentHashMap<String, AccsClientConfig>(1);
        mPreviewConfigs = new ConcurrentHashMap<String, AccsClientConfig>(1);
        mDebugConfigs = new ConcurrentHashMap<String, AccsClientConfig>(1);
        try {
            Bundle bundle = k.g(AccsClientConfig.getContext());
            if (bundle != null) {
                String[] stringArray = bundle.getString("accsConfigTags", null);
                ALog.i(TAG, "init config from xml", "configtags", stringArray);
                if (!TextUtils.isEmpty((CharSequence)stringArray)) {
                    String[] stringArray2 = stringArray.split("\\|");
                    if (stringArray2 == null) {
                        stringArray2 = new String[]{stringArray};
                    }
                    stringArray = stringArray2;
                    int n2 = stringArray2.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string = stringArray[i2];
                        if (TextUtils.isEmpty((CharSequence)string)) continue;
                        int n3 = bundle.getInt(string + "_accsAppkey", -1);
                        String string2 = n3 < 0 ? null : String.valueOf(n3);
                        String string3 = bundle.getString(string + "_accsAppSecret");
                        String string4 = bundle.getString(string + "_authCode");
                        boolean bl = bundle.getBoolean(string + "_keepAlive", true);
                        boolean bl2 = bundle.getBoolean(string + "_autoUnit", true);
                        int n4 = bundle.getInt(string + "_inappPubkey", -1);
                        int n5 = bundle.getInt(string + "_channelPubkey", -1);
                        String string5 = bundle.getString(string + "_inappHost");
                        String string6 = bundle.getString(string + "_channelHost");
                        int n6 = bundle.getInt(string + "_configEnv", 0);
                        boolean bl3 = bundle.getBoolean(string + "_disableChannel");
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        new Builder().setTag(string).setConfigEnv(n6).setAppKey(string2).setAppSecret(string3).setAutoCode(string4).setKeepAlive(bl).setAutoUnit(bl2).setInappHost(string5).setInappPubKey(n4).setChannelHost(string6).setChannelPubKey(n5).setDisableChannel(bl3).build();
                        ALog.i(TAG, "init config from xml", new Object[0]);
                    }
                    loadedStaticConfig = true;
                }
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "init config from xml", throwable, new Object[0]);
        }
    }

    public static class Builder {
        private String mAppKey;
        private String mTag;
        private String mAppSecret;
        private String mInappHost;
        private String mChannelHost;
        private String mAuthCode;
        private String mStoreId;
        private int mInappPubKey = -1;
        private int mChannelPubKey = -1;
        private boolean mKeepalive = true;
        private boolean mAutoUnit = true;
        private int mConfigEnv = -1;
        private boolean mDisableChannel = false;
        private boolean mQuickReconnect = false;
        private boolean mAccsHeartbeatEnable = false;

        public Builder setAppKey(String string) {
            this.mAppKey = string;
            return this;
        }

        public Builder setAppSecret(String string) {
            this.mAppSecret = string;
            return this;
        }

        public Builder setInappHost(String string) {
            this.mInappHost = string;
            return this;
        }

        public Builder setChannelHost(String string) {
            this.mChannelHost = string;
            return this;
        }

        public Builder setAutoCode(String string) {
            this.mAuthCode = string;
            return this;
        }

        public Builder setInappPubKey(int n2) {
            this.mInappPubKey = n2;
            return this;
        }

        public Builder setChannelPubKey(int n2) {
            this.mChannelPubKey = n2;
            return this;
        }

        public Builder setKeepAlive(boolean bl) {
            this.mKeepalive = bl;
            return this;
        }

        public Builder setAutoUnit(boolean bl) {
            this.mAutoUnit = bl;
            return this;
        }

        public Builder setConfigEnv(@ENV int n2) {
            this.mConfigEnv = n2;
            return this;
        }

        public Builder setStoreId(String string) {
            this.mStoreId = string;
            return this;
        }

        public Builder setTag(String string) {
            this.mTag = string;
            return this;
        }

        public Builder setDisableChannel(boolean bl) {
            this.mDisableChannel = bl;
            return this;
        }

        public Builder setQuickReconnect(boolean bl) {
            this.mQuickReconnect = bl;
            return this;
        }

        public Builder setAccsHeartbeatEnable(boolean bl) {
            this.mAccsHeartbeatEnable = bl;
            return this;
        }

        public AccsClientConfig build() throws AccsException {
            Map map;
            if (TextUtils.isEmpty((CharSequence)this.mAppKey)) {
                throw new AccsException("appkey null");
            }
            AccsClientConfig accsClientConfig = new AccsClientConfig();
            accsClientConfig.mAppKey = this.mAppKey;
            accsClientConfig.mAppSecret = this.mAppSecret;
            accsClientConfig.mAuthCode = this.mAuthCode;
            accsClientConfig.mKeepalive = this.mKeepalive;
            accsClientConfig.mAutoUnit = this.mAutoUnit;
            accsClientConfig.mInappPubKey = this.mInappPubKey;
            accsClientConfig.mChannelPubKey = this.mChannelPubKey;
            accsClientConfig.mInappHost = this.mInappHost;
            accsClientConfig.mChannelHost = this.mChannelHost;
            accsClientConfig.mTag = this.mTag;
            accsClientConfig.mStoreId = this.mStoreId;
            accsClientConfig.mConfigEnv = this.mConfigEnv;
            accsClientConfig.mDisableChannel = this.mDisableChannel;
            accsClientConfig.mQuickReconnect = this.mQuickReconnect;
            accsClientConfig.mAccsHeartbeatEnable = this.mAccsHeartbeatEnable;
            if (accsClientConfig.mConfigEnv < 0) {
                accsClientConfig.mConfigEnv = mEnv;
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mAppSecret)) {
                accsClientConfig.mSecurity = 0;
            } else {
                accsClientConfig.mSecurity = 2;
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mInappHost)) {
                accsClientConfig.mInappHost = DEFAULT_CENTER_HOSTS[accsClientConfig.mConfigEnv];
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mChannelHost)) {
                accsClientConfig.mChannelHost = DEFAULT_CHANNEL_HOSTS[accsClientConfig.mConfigEnv];
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mTag)) {
                accsClientConfig.mTag = accsClientConfig.mAppKey;
            }
            switch (accsClientConfig.mConfigEnv) {
                case 1: {
                    map = mPreviewConfigs;
                    break;
                }
                case 2: {
                    map = mDebugConfigs;
                    break;
                }
                default: {
                    map = mReleaseConfigs;
                }
            }
            ALog.d(AccsClientConfig.TAG, "build", "config", accsClientConfig);
            AccsClientConfig accsClientConfig2 = (AccsClientConfig)map.get(accsClientConfig.getTag());
            if (accsClientConfig2 != null) {
                ALog.w(AccsClientConfig.TAG, "build conver", "old config", accsClientConfig2);
            }
            map.put(accsClientConfig.getTag(), accsClientConfig);
            return accsClientConfig;
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface ENV {
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface SECURITY_TYPE {
    }
}

