/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.ams.common.util;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtil {
    public static final String SDK_CACHE_PATH = "aliCloud";

    public static File getExternalStorageDirectory(Context object, String string) {
        object = FileUtil.isCanUseSDCard() ? new File(Environment.getExternalStorageDirectory(), string) : new File(FileUtil.getCacheDir((Context)object), string);
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        return object;
    }

    public static File getCachePath(Context context) {
        return FileUtil.getExternalStoragePublicDirectory(context, SDK_CACHE_PATH);
    }

    public static File getExternalStoragePublicDirectory(Context object, String string) {
        object = FileUtil.isCanUseSDCard() ? new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS), string) : new File(FileUtil.getCacheDir((Context)object), string);
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        return object;
    }

    public static boolean isCanUseSDCard() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static File getCacheDir(Context object) {
        object = FileUtil.isCanUseSDCard() ? (Build.VERSION.SDK_INT >= 8 ? object.getExternalCacheDir() : FileUtil.a((Context)object)) : object.getCacheDir();
        if (object != null && !((File)object).exists()) {
            ((File)object).mkdirs();
        }
        return object;
    }

    public static File getExternalCacheDir(Context context) {
        File file = null;
        if (FileUtil.isCanUseSDCard()) {
            file = Build.VERSION.SDK_INT >= 8 ? context.getExternalCacheDir() : FileUtil.a(context);
        }
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private static final File a(Context context) {
        return new File(Environment.getExternalStorageDirectory(), "/Android/data/" + context.getApplicationInfo().packageName + "/cache/");
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        FileUtil.copyStream(inputStream, outputStream, true);
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        int n2;
        byte[] byArray = new byte[8192];
        while (!Thread.interrupted() && (n2 = inputStream.read(byArray, 0, 8192)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
        outputStream.flush();
        if (bl) {
            outputStream.close();
        }
    }

    public static String generate(String string) {
        return String.valueOf(string.hashCode());
    }
}

