/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.util;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import anet.channel.AwcnConfig;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.thread.ThreadPoolExecutorFactory;
import anet.channel.util.ALog;
import java.util.concurrent.CopyOnWriteArraySet;

public class AppLifecycle {
    private static CopyOnWriteArraySet<AppLifecycleListener> listeners = new CopyOnWriteArraySet();
    public static volatile long lastEnterBackgroundTime = 0L;
    private static Application.ActivityLifecycleCallbacks mActivityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public final void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public final void onActivityStarted(Activity activity) {
        }

        public final void onActivityResumed(Activity activity) {
            AppLifecycle.onForeground();
        }

        public final void onActivityPaused(Activity activity) {
        }

        public final void onActivityStopped(Activity activity) {
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public final void onActivityDestroyed(Activity activity) {
        }
    };
    private static ComponentCallbacks2 mComponentCallbacks2 = new ComponentCallbacks2(){
        public static final String TAG = "awcn.ComponentCallbacks2";

        public final void onTrimMemory(int n2) {
            ALog.i(TAG, "onTrimMemory", null, "level", n2);
            if (n2 == 20) {
                AppLifecycle.onBackground();
            }
        }

        public final void onConfigurationChanged(Configuration configuration) {
        }

        public final void onLowMemory() {
        }
    };

    private AppLifecycle() {
    }

    public static void initialize() {
        if (Build.VERSION.SDK_INT >= 14 && AwcnConfig.isAppLifeCycleListenerEnable()) {
            ((Application)GlobalAppRuntimeInfo.getContext().getApplicationContext()).registerActivityLifecycleCallbacks(mActivityLifecycleCallbacks);
            GlobalAppRuntimeInfo.getContext().registerComponentCallbacks((ComponentCallbacks)mComponentCallbacks2);
        }
    }

    public static void registerLifecycleListener(AppLifecycleListener appLifecycleListener) {
        if (appLifecycleListener != null) {
            listeners.add(appLifecycleListener);
        }
    }

    public static void unregisterLifecycleListener(AppLifecycleListener appLifecycleListener) {
        listeners.remove(appLifecycleListener);
    }

    public static void onForeground() {
        if (GlobalAppRuntimeInfo.isAppBackground()) {
            GlobalAppRuntimeInfo.setBackground(false);
            AppLifecycle.notifyListener(true);
        }
    }

    public static void onBackground() {
        if (!GlobalAppRuntimeInfo.isAppBackground()) {
            GlobalAppRuntimeInfo.setBackground(true);
            lastEnterBackgroundTime = System.currentTimeMillis();
            AppLifecycle.notifyListener(false);
        }
    }

    private static void notifyListener(final boolean bl) {
        ALog.i("awcn.AppLifeCycle", "notifyListener", null, "foreground", bl);
        ThreadPoolExecutorFactory.submitScheduledTask(new Runnable(){

            @Override
            public final void run() {
                for (AppLifecycleListener appLifecycleListener : listeners) {
                    if (bl) {
                        appLifecycleListener.forground();
                        continue;
                    }
                    appLifecycleListener.background();
                }
            }
        });
    }

    public static interface AppLifecycleListener {
        public void forground();

        public void background();
    }
}

