/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.rogers.receiver;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.fshows.android.rogers.manager.GeTuiManager;
import com.fshows.android.rogers.manager.PushChannel;
import com.fshows.android.rogers.mix.MixPushMessage;
import com.fshows.android.rogers.push.IPushChannel;
import com.fshows.android.stark.log.BaseLogModel;
import com.fshows.android.stark.log.FsPushBackBean;
import com.fshows.android.stark.log.PushLogServer;
import com.igexin.sdk.GTIntentService;
import com.igexin.sdk.PushManager;
import com.igexin.sdk.message.GTCmdMessage;
import com.igexin.sdk.message.GTNotificationMessage;
import com.igexin.sdk.message.GTTransmitMessage;
import org.json.JSONObject;

public class GeTuiMessageIntentService
extends GTIntentService
implements IPushChannel {
    private static final String TAG = GeTuiMessageIntentService.class.getSimpleName();

    @Override
    public String getPushName() {
        return PushChannel.getui.name();
    }

    public void onReceiveServicePid(Context context, int pid) {
        Log.d((String)TAG, (String)("onReceiveServicePid -> " + pid));
    }

    public void onReceiveMessageData(Context context, GTTransmitMessage msg) {
        String taskId = msg.getTaskId();
        String messageId = msg.getMessageId();
        try {
            boolean geTuiCallBack = PushManager.getInstance().sendFeedbackMessage(context, taskId, messageId, 90001);
            byte[] payload = msg.getPayload();
            String data = new String(payload);
            Log.e((String)TAG, (String)("\u4e2a\u63a8\u6536\u5230\u6d88\u606f\uff1a" + data));
            PushLogServer.getLogServer().uploadLog((BaseLogModel)new FsPushBackBean(context, data, geTuiCallBack, taskId, messageId));
            JSONObject object = new JSONObject(data);
            int source = object.optInt("source", 0);
            MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
            mixPushMessage.setSource(source);
            if (source == 1) {
                PushLogServer.getLogServer().uploadLog((BaseLogModel)new FsPushBackBean(context, "\u4e2a\u63a8\u65b0\u63a8\u9001\u7cfb\u7edf", taskId, messageId));
                int pushType = object.optInt("pushType", 0);
                String pushId = object.optString("pushId");
                mixPushMessage.setPushId(pushId);
                mixPushMessage.setPushType(pushType);
                if (pushType == 3) {
                    mixPushMessage.setContent(data);
                    GeTuiManager.sMixMessageProvider.onNotificationMessageArrived(context, mixPushMessage);
                } else if (pushType == 2) {
                    mixPushMessage.setMsgObject(data);
                    GeTuiManager.sMixMessageProvider.onNotificationMessageClicked(context, mixPushMessage);
                } else {
                    mixPushMessage.setContent(data);
                    GeTuiManager.sMixMessageProvider.onReceivePassThroughMessage(context, mixPushMessage);
                }
            } else {
                PushLogServer.getLogServer().uploadLog((BaseLogModel)new FsPushBackBean(context, "\u4e2a\u63a8\u65e7\u63a8\u9001\u7cfb\u7edf", taskId, messageId));
                JSONObject msgObject = object.getJSONObject("on_message");
                int passType = msgObject.getInt("pass_type");
                if (passType == 1) {
                    mixPushMessage.setContent(data);
                    GeTuiManager.sMixMessageProvider.onReceivePassThroughMessage(context, mixPushMessage);
                } else {
                    mixPushMessage.setMsgObject(msgObject.toString());
                    GeTuiManager.sMixMessageProvider.onNotificationMessageClicked(context, mixPushMessage);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PushLogServer.getLogServer().uploadLog((BaseLogModel)new FsPushBackBean(context, "\u4e2a\u63a8\u6570\u636e\u89e3\u6790\u5931\u8d25" + e.toString(), taskId, messageId));
        }
    }

    public void onReceiveClientId(Context context, String clientId) {
        Log.d((String)TAG, (String)("onReceiveClientId: clientId = " + clientId));
        MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
        mixPushMessage.setCid(clientId);
        GeTuiManager.sMixMessageProvider.onReceiveClientId(context, mixPushMessage);
    }

    public void onReceiveOnlineState(Context context, boolean online) {
        Log.e((String)TAG, (String)("onReceiveOnlineState: " + (online ? "online" : "offline")));
    }

    public void onReceiveCommandResult(Context context, GTCmdMessage cmdMessage) {
        Log.e((String)TAG, (String)("onReceiveCommandResult: " + cmdMessage));
    }

    public void onNotificationMessageArrived(Context context, GTNotificationMessage gtNotificationMessage) {
        Log.e((String)TAG, (String)("onNotificationMessageArrived-getContent: " + gtNotificationMessage.getContent()));
        if (TextUtils.equals((CharSequence)"\u65e5\u62a5", (CharSequence)gtNotificationMessage.getTitle()) || TextUtils.equals((CharSequence)"\u5468\u62a5", (CharSequence)gtNotificationMessage.getTitle()) || TextUtils.equals((CharSequence)"\u6708\u62a5", (CharSequence)gtNotificationMessage.getTitle())) {
            MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
            mixPushMessage.setSource(0);
            mixPushMessage.setPushType(11);
            GeTuiManager.sMixMessageProvider.onNotificationMessageArrived(context, mixPushMessage);
        }
    }

    public void onNotificationMessageClicked(Context context, GTNotificationMessage gtNotificationMessage) {
        Log.e((String)TAG, (String)"onNotificationMessageClicked");
    }
}

