/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.push;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.alibaba.sdk.android.ams.common.global.AmsGlobalSetter;
import com.alibaba.sdk.android.ams.common.logger.AmsLogger;
import com.alibaba.sdk.android.ams.common.securitybox.SecurityBoxServiceFactory;
import com.alibaba.sdk.android.ams.common.util.StringUtil;
import com.alibaba.sdk.android.push.vip.AppRegister;
import com.taobao.accs.base.TaoBaseService;

public abstract class AgooMessageReceiver
extends BroadcastReceiver {
    public static final String NOTIFICATION_OPENED_ACTION = "com.alibaba.push2.action.NOTIFICATION_OPENED";
    public static final String NOTIFICATION_REMOVED_ACTION = "com.alibaba.push2.action.NOTIFICATION_REMOVED";
    public static final String MESSAGE_ID = "messageId";
    public static final String TITLE = "title";
    public static final String SUMMARY = "summary";
    public static final String EXTRA_MAP = "extraMap";
    public static final String NOTIFICATION_OPEN_TYPE = "notificationOpenType";
    public static final String NOTIFICATION_ID = "notificationId";
    public static final String TAG = "MPS:AgooMessageReceiver";
    static AmsLogger logger = AmsLogger.getLogger("MPS:AgooMessageReceiver");

    public void onReceive(Context context, Intent intent) {
        logger.d("AgooMessageReceiver onReceive begin...intent=" + intent);
        AmsGlobalSetter.setAndroidAppContext(context);
        AmsGlobalSetter.setPlatform(SecurityBoxServiceFactory.getSecurityBoxService().getPlatform());
        boolean bl = AppRegister.a().b();
        String string = intent.getAction();
        if (StringUtil.isEmpty(string)) {
            return;
        }
        try {
            TaoBaseService.ConnectInfo connectInfo;
            if (TextUtils.equals((CharSequence)"com.alibaba.sdk.android.push.RECEIVE", (CharSequence)string)) {
                this.onHandleCall(context, intent);
                return;
            }
            if (TextUtils.equals((CharSequence)NOTIFICATION_OPENED_ACTION, (CharSequence)string)) {
                String string2 = intent.getStringExtra(TITLE);
                string = intent.getStringExtra(SUMMARY);
                String string3 = intent.getStringExtra(EXTRA_MAP);
                int n2 = intent.getIntExtra(NOTIFICATION_OPEN_TYPE, 1);
                if (4 == n2) {
                    logger.d("notification opened without action");
                    this.onNotificationClickedWithNoAction(context, string2, string, string3);
                    return;
                }
                logger.d("notification opened");
                this.onNotificationOpened(context, string2, string, string3);
                return;
            }
            if (TextUtils.equals((CharSequence)NOTIFICATION_REMOVED_ACTION, (CharSequence)string)) {
                String string4 = intent.getStringExtra(MESSAGE_ID);
                this.onNotificationRemoved(context, string4);
                logger.d("Delete message! --" + string4);
                return;
            }
            if ((TextUtils.equals((CharSequence)string, (CharSequence)"android.net.conn.CONNECTIVITY_CHANGE") || TextUtils.equals((CharSequence)string, (CharSequence)"android.intent.action.BOOT_COMPLETED") || TextUtils.equals((CharSequence)string, (CharSequence)"android.intent.action.PACKAGE_ADDED") || TextUtils.equals((CharSequence)string, (CharSequence)"android.intent.action.PACKAGE_REPLACED") || TextUtils.equals((CharSequence)string, (CharSequence)"android.intent.action.USER_PRESENT") || TextUtils.equals((CharSequence)string, (CharSequence)"android.intent.action.ACTION_POWER_CONNECTED") || TextUtils.equals((CharSequence)string, (CharSequence)"android.intent.action.ACTION_POWER_DISCONNECTED")) && bl) {
                logger.d("USER ACTION: " + string);
                return;
            }
            if (TextUtils.equals((CharSequence)string, (CharSequence)"com.taobao.accs.intent.action.CONNECTINFO") && (connectInfo = (TaoBaseService.ConnectInfo)intent.getExtras().get("connect_info")) != null) {
                this.onConnectionStatusChanged(connectInfo.connected);
            }
            return;
        }
        catch (Throwable throwable) {
            logger.e("handle action error:", throwable);
            return;
        }
    }

    protected abstract void onHandleCall(Context var1, Intent var2);

    protected abstract void onNotificationOpened(Context var1, String var2, String var3, String var4);

    protected abstract void onNotificationRemoved(Context var1, String var2);

    protected abstract void onNotificationClickedWithNoAction(Context var1, String var2, String var3, String var4);

    protected abstract void onConnectionStatusChanged(boolean var1);
}

