/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.bytes;

import anet.channel.bytes.a;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArray
implements Comparable<ByteArray> {
    final byte[] buffer;
    int bufferLength;
    int dataLength;

    private ByteArray(byte[] byArray, int n2) {
        this.buffer = byArray == null ? new byte[n2] : byArray;
        this.bufferLength = this.buffer.length;
        this.dataLength = n2;
    }

    public static ByteArray create(int n2) {
        return new ByteArray(null, n2);
    }

    public static ByteArray wrap(byte[] byArray, int n2) {
        if (byArray == null || n2 < 0 || n2 > byArray.length) {
            return null;
        }
        return new ByteArray(byArray, n2);
    }

    public static ByteArray wrap(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return ByteArray.wrap(byArray, byArray.length);
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getBufferLength() {
        return this.bufferLength;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int n2) {
        this.dataLength = n2;
    }

    public void recycle() {
        if (this.bufferLength == 0) {
            return;
        }
        a.a.a.a(this);
    }

    public int readFrom(InputStream inputStream) throws IOException {
        int n2 = inputStream.read(this.buffer, 0, this.bufferLength);
        this.dataLength = n2 != -1 ? n2 : 0;
        return n2;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buffer, 0, this.dataLength);
    }

    @Override
    public int compareTo(ByteArray byteArray) {
        if (this.bufferLength == byteArray.bufferLength) {
            if (this.buffer == null) {
                return -1;
            }
            if (byteArray.buffer == null) {
                return 1;
            }
            return this.hashCode() - byteArray.hashCode();
        }
        return this.bufferLength - byteArray.bufferLength;
    }
}

